/*
 * The JabaJaba class library
 *  Copyright (C) 1997-1999  ASAMI, Tomoharu (tasami@ibm.net)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.awt.lwlayout;

import java.util.*;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import jp.gr.java_conf.jaba2.awt.*;

/**
 * ColumnLightWeightLayout
 *
 * @since   Jan.  7, 1999
 * @version Jan.  7, 1999
 * @author  ASAMI, Tomoharu (tasami@ibm.net)
 */
public class ColumnLightWeightLayout extends AbstractLightWeightLayoutManager
    implements LayoutConstants {

    protected AdapterLightWeightLayout adapter_;

    public ColumnLightWeightLayout() {
	adapter_ = new AdapterLightWeightLayout(new ColumnLayout());
    }

    public void addLayoutComponent(Component comp, Object constraints) {
	adapter_.addLayoutComponent(comp, constraints);
    }

    public void removeLayoutComponent(Component comp) {
	adapter_.removeLayoutComponent(comp);
    }

    public void layoutComponents(Rectangle bounds) {
	adapter_.layoutComponents(bounds);
    }

    public Dimension preferredLayoutSize() {
	return (adapter_.preferredLayoutSize());
    }

    public Dimension minimumLayoutSize() {
	return (adapter_.minimumLayoutSize());
    }
}
