/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2000  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.dombus;

import jp.gr.java_conf.jaba2.dombus.configRelaxer.CSlot;

/**
 * MTComponentSlot
 *
 * @since   Mar. 29, 2000
 * @version Jul. 21, 2000
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
class MTComponentSlot extends AbstractComponentSlot {
    private DOMBusQueue queue_ = new DOMBusQueue();
    private boolean isAlive_ = true;

    public MTComponentSlot(IDOMBusComponent component, CSlot slot) {
	super(component, slot);
	new Thread() {
	    public void run() {
		while (isAlive_) {
		    DOMBusSignal signal = queue_.getSignalWait();
		    Object result = component_.fire(signal);
		    signal.consume();
		    if (post_ != null) {
			post_.fire(result);
		    }
		}
	    }
	};
    }

    public boolean stimulus(DOMBusSignal signal) {
	if (guard_.isAccept(signal)) {
	    queue_.putSignal(signal);
	    return (true);
	} else {
	    signal.consume();
	    return (false);
	}
    }
}
