package jp.gr.java_conf.jaba2.io;

import java.util.*;
import java.io.*;
import javax.swing.*;
import javax.swing.tree.*;

/**
 * FileTreeNode
 * 
 * @since   Apr.  3, 1998
 * @version Nov. 20, 1998
 * @author  ASAMI, Tomoharu (tasami@ibm.net)
 */
public class FileTreeNode implements TreeNode {
    protected File node_;
    protected FileTreeNode parent_;
    protected FileTreeNode[] children_ = null;
    protected boolean showFile_ = true;

    public FileTreeNode(File root) {
	_init(null, root, showFile_);
    }

    public FileTreeNode(File root, boolean showFile) {
	_init(null, root, showFile);
    }

    protected FileTreeNode(FileTreeNode parent, File node, boolean showFile) {
	_init(parent, node, showFile);
    }

    private void _init(FileTreeNode parent, File node, boolean showFile) {
	parent_ = parent;
	node_ = node;
	showFile_ = showFile;
    }

    public TreeNode getChildAt(int childIndex) {
	_ensureChildren();
	return (children_[childIndex]);
    }

    public int getChildCount() {
	_ensureChildren();
	return (children_.length);
    }

    public TreeNode getParent() {
	return (parent_);
    }

    public int getIndex(TreeNode node) {
	_ensureChildren();
	for (int i = 0;i < children_.length;i++) {
	    if (children_[i].equals(node)) {
		return (i);
	    }
	}
	return (-1);
    }

    public boolean getAllowsChildren() {
	return (node_.isDirectory());
    }

    public boolean isLeaf() {
	return (node_.isFile());
    }

    public Enumeration children() {
	_ensureChildren();
	return (new Enumeration() {
	    public boolean hasMoreElements() {
		return (index < children_.length);
	    }

	    public Object nextElement() {
		return (children_[index++]);
	    }

	    private int index = 0;
	});
    }

    public String toString() {
	return (node_.getName());
    }

    public File getFile() {
	return (node_);
    }

    private void _ensureChildren() {
	if (children_ != null) {
	    return;
	}
	String[] names;
	if (showFile_) {
	    names = node_.list();
	} else {
	    names = node_.list(new DirectoryFilenameFilter());
	}
	if (names == null) {
	    names = new String[0];
	}
	children_ = new FileTreeNode[names.length];
	for (int i = 0;i < names.length;i++) {
	    children_[i] = new FileTreeNode(
		this,
		new File(node_, names[i]),
		showFile_
	    );
	}
    }

    // test driver
    public static void main(String[] args) throws Exception {
	javax.swing.JFrame frame
	    = new javax.swing.JFrame("FileTreeNode");
	frame.addWindowListener(new java.awt.event.WindowAdapter() {
	    public void windowClosing(java.awt.event.WindowEvent evt) {
		System.exit(0);
	    }
	});
	java.awt.Container pane = frame.getContentPane();
	pane.add(new javax.swing.JScrollPane(new javax.swing.JTree(new FileTreeNode(new File("/")))));
	UIManager.setLookAndFeel("javax.swing.jlf.JLFLookAndFeel");
	SwingUtilities.updateComponentTreeUI(frame);
	frame.pack();
	frame.show();
    }
}
