package jp.gr.java_conf.jaba2.j2fw.sample;

import java.io.*;
import jp.gr.java_conf.jaba2.j2fw.*;

/**
 * ShellContext
 *
 * @since   Feb.  9, 1999
 * @version Feb.  9, 1999
 * @author  ASAMI, Tomoharu (tasami@ibm.net)
 */
public class ShellContext extends J2Context {
    protected ShellConfig config_;
    protected ShellModel model_;
    protected ShellController controller_;

    public ShellContext() {
    }

    public ShellContext(
	ShellConfig config,
	ShellModel model,
	ShellController controller
    ) {
	super(config, model, controller);
	config_ = config;
	model_ = model;
	controller_ = controller;
    }

    public void setConfig(ShellConfig config) {
	setJ2Config(config);
	config_ = config;
    }

    public void setModel(ShellModel model) {
	setJ2Model(model);
	model_ = model;
    }

    public void setController(ShellController controller) {
	setJ2Controller(controller);
	controller_ = controller;
    }

    public ShellConfig getConfig() {
	return (config_);
    }

    public ShellModel getModel() {
	return (model_);
    }

    public ShellController getController() {
	return (controller_);
    }

    public J2Monitor getMonitor() {
	return (getJ2Monitor());
    }

    protected static ShellContext context__;

    public static ShellContext getContext() {
	return (context__);
    }

    public static void setContext(ShellContext context) {
	J2Context.setJ2Context(context);
	context__ = context;
    }
}
