/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2002  ASAMI, Tomoharu (asami@AsamiOffice.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.jmodel.beans;

import jp.gr.java_conf.jaba2.text.UString;
import jp.gr.java_conf.jaba2.jmodel.lang.*;

/**
 * UBJModel
 *
 * @since   Jan. 18, 2000
 * @version May. 16, 2002
 * @author  ASAMI, Tomoharu (asami@AsamiOffice.com)
 */
public final class UBJModel implements IAccessMode {
    public static LJModel bean2lang(BJModel model) {
	LJModel ljmodel = new LJModel();
	BJBean[] beans = model.getBeans();
	for (int i = 0;i < beans.length;i++) {
	    ljmodel.addClass(bean2class(beans[i], ljmodel));
	}
	return (ljmodel);
    }

    public static LJClass bean2class(BJBean bean, LJModel ljmodel) {
	LJClass ljclass = new LJClass(bean.getName(), ACCESS_PUBLIC, bean);
	setupBeans(bean, ljclass, ljmodel);
	BJProperty[] properties = bean.getProperties();
	for (int i = 0;i < properties.length;i++) {
	    BJProperty property = properties[i];
	    if (property instanceof BJListProperty) {
		setupProperty(
		    (BJListProperty)property,
		    ljclass,
		    ljmodel,
		    bean.isPropertyChange(),
		    bean.isVetoableChange()
		);
	    } else {
		setupProperty(
		    property,
		    ljclass,
		    ljmodel,
		    bean.isPropertyChange(),
		    bean.isVetoableChange()
		);
	    }
	}
//System.out.println("class2");
//_junk(ljclass);
	return (ljclass);
    }

    public static void bean2class(
	BJBean bean,
	LJClass ljclass,
	LJModel ljmodel
    ) {
	ljclass.setup(bean);
	setupBeans(bean, ljclass, ljmodel);
	BJProperty[] properties = bean.getProperties();
	for (int i = 0;i < properties.length;i++) {
	    BJProperty property = properties[i];
	    if (property instanceof BJListProperty) {
		setupProperty(
		    (BJListProperty)property,
		    ljclass,
		    ljmodel,
		    bean.isPropertyChange(),
		    bean.isVetoableChange()
		);
	    } else {
		setupProperty(
		    property,
		    ljclass,
		    ljmodel,
		    bean.isPropertyChange(),
		    bean.isVetoableChange()
		);
	    }
	}
//System.out.println("bean2class");
//System.out.println("bean");
//_junk(bean);
//System.out.println("class");
//_junk(ljclass);
    }

/*
private static void _junk(LJClass c) {
    LJMethod[] methods = c.getMethods();
    for (int i = 0;i < methods.length;i++) {
	LJMethod m = methods[i];
	System.out.println(m.getProperties());
    }
}
*/

    public static void setupBeans(
	BJBean bean,
	LJClass ljclass,
	LJModel model
    ) {
	if (!(bean.isPropertyChange() || bean.isVetoableChange())) {
	    return;
	}
	ljclass.addImportPackage("java.beans.*");
	if (bean.isPropertyChange()) {
	    LJAttribute attr = new LJAttribute(
		"$propertyChangeSupport$",
		model.getType("PropertyChangeSupport"),
		ACCESS_PRIVATE
	    );
	    ljclass.addAttribute(attr);
	    _addAddPropertyChangeListenerMethod(ljclass, model);
	    _addRemovePropertyChangeListenerMethod(ljclass, model);
	    _addFirePropertyChangeMethod(ljclass, model);
	}
	if (bean.isVetoableChange()) {
	    LJAttribute attr = new LJAttribute(
		"$vetoableChangeSupport$",
		model.getType("VetoableChangeSupport"),
		ACCESS_PRIVATE
	    );
	    ljclass.addAttribute(attr);
	    _addAddVetoableChangeListenerMethod(ljclass, model);
	    _addRemoveVetoableChangeListenerMethod(ljclass, model);
	    // XXX : need helper
	}
    }

    private static void _addAddPropertyChangeListenerMethod(
	LJClass ljClass,
	LJModel model
    ) {
	LJMethod method = new LJMethod(
	    "addPropertyChangeListener",
	    ACCESS_PUBLIC,
	    model.getType("void"),
	    new LJArgument(
		"listener",
		model.getType("PropertyChangeListener")
	    )
	);
	method.setProperty("systemMethod", Boolean.TRUE);
	StringBuffer buffer = new StringBuffer();
	buffer.append("if (listener == null) {\n");
	buffer.append("@return;\n");
	buffer.append("}\n");
	buffer.append("if ($propertyChangeSupport$ == null) {\n");
	buffer.append("@$propertyChangeSupport$ = new PropertyChangeSupport(this);\n");
	buffer.append("}\n");
	buffer.append("$propertyChangeSupport$.addPropertyChangeListener(listener);\n");
	method.setImplementation(new String(buffer));
	ljClass.addMethod(method);
    }

    private static void _addRemovePropertyChangeListenerMethod(
	LJClass ljClass,
	LJModel model
    ) {
	LJMethod method = new LJMethod(
	    "removePropertyChangeListener",
	    ACCESS_PUBLIC,
	    model.getType("void"),
	    new LJArgument(
		"listener",
		model.getType("PropertyChangeListener")
	    )
	);
	method.setProperty("systemMethod", Boolean.TRUE);
	StringBuffer buffer = new StringBuffer();
	buffer.append("if (listener == null) {\n");
	buffer.append("@return;\n");
	buffer.append("}\n");
	buffer.append("if ($propertyChangeSupport$ == null) {\n");
	buffer.append("@return;\n");
	buffer.append("}\n");
	buffer.append("$propertyChangeSupport$.removePropertyChangeListener(listener);\n");
	method.setImplementation(new String(buffer));
	ljClass.addMethod(method);
    }

    private static void _addFirePropertyChangeMethod(
	LJClass ljClass,
	LJModel model
    ) {
	LJMethod method = new LJMethod(
	    "firePropertyChange",
	    ACCESS_PROTECTED,
	    model.getType("void"),
	    new LJArgument[] {
		new LJArgument("name", model.getType("String")),
		new LJArgument("oldValue", model.getType("Object")),
		new LJArgument("newValue", model.getType("Object"))
	    }
	);
	method.setProperty("systemMethod", Boolean.TRUE);
	StringBuffer buffer = new StringBuffer();
	buffer.append("$propertyChangeSupport$.firePropertyChange(name, oldValue, newValue);\n");
	method.setImplementation(new String(buffer));
	ljClass.addMethod(method);
    }

    private static void _addAddVetoableChangeListenerMethod(
	LJClass ljClass,
	LJModel model
    ) {
	LJMethod method = new LJMethod(
	    "addVetoableChangeListener",
	    ACCESS_PUBLIC,
	    model.getType("void"),
	    new LJArgument(
		"listener",
		model.getType("VetoableChangeListener")
	    )
	);
	method.setProperty("systemMethod", Boolean.TRUE);
	StringBuffer buffer = new StringBuffer();
	buffer.append("if (listener == null) {\n");
	buffer.append("@return;\n");
	buffer.append("}\n");
	buffer.append("if ($vetoableChangeSupport$ == null) {\n");
	buffer.append("@changeSupport = new VetoableChangeSupport(this);\n");
	buffer.append("}\n");
	buffer.append("$vetoableChangeSupport$.addVetoableChangeListener(listener);\n");
	method.setImplementation(new String(buffer));
	ljClass.addMethod(method);
    }

    private static void _addRemoveVetoableChangeListenerMethod(
	LJClass ljClass,
	LJModel model
    ) {
	LJMethod method = new LJMethod(
	    "removeVetoableChangeListener",
	    ACCESS_PUBLIC,
	    model.getType("void"),
	    new LJArgument(
		"listener",
		model.getType("VetoableChangeListener")
	    )
	);
	method.setProperty("systemMethod", Boolean.TRUE);
	StringBuffer buffer = new StringBuffer();
	buffer.append("if (listener == null) {\n");
	buffer.append("@return;\n");
	buffer.append("}\n");
	buffer.append("if ($vetoableChangeSupport$ == null) {\n");
	buffer.append("@return;\n");
	buffer.append("}\n");
	buffer.append("$vetoableChangeSupport$.removeVetoableChangeListener(listener);\n");
	method.setImplementation(new String(buffer));
	ljClass.addMethod(method);
    }

    public static void setupProperty(
	BJListProperty property,
	LJClass ljclass,
	LJModel ljmodel,
	boolean propertyChange,
	boolean vetoableChange
    ) {
	LJType ptype = property.getType();
	if (_getObjectType(ptype.getName()) != null) { // primitive
	    _setupPropertyPrimitive(
		property,
		ljclass,
		ljmodel,
		propertyChange,
		vetoableChange
	    );
	} else {
	    _setupProperty(
		property,
		ljclass,
		ljmodel,
		propertyChange,
		vetoableChange
	    );
	}
    }

    private static void _setupProperty(
	BJListProperty property,
	LJClass ljclass,
	LJModel ljmodel,
	boolean propertyChange,
	boolean vetoableChange
    ) {
	String pname = property.getName();
	String vname = property.getVarName();
	String paramName = property.getParamName();
	LJType ptype = property.getType();
	LJType atype = ljmodel.getArrayType(ptype);
	LJType ctype = ljmodel.getListType(ptype);
	LJAttribute pattr = new LJAttribute(vname, ctype, ACCESS_PRIVATE);
	ljclass.addAttribute(pattr);

	LJMethod getter = new LJMethod(
	    "get" + UString.capitalize(pname),
	    ACCESS_PUBLIC,
	    atype
	);
	getter.setDescription(
	    "Gets the " + ptype.getName() + " property <b>" + pname + "</b>."
	);
	getter.setFinal(useFinal__);
	getter.setImplementation(_makeGetterAsArrayCode(ctype, ptype, vname));
	getter.setProperties(property.getProperties());
	ljclass.addMethod(getter);

	LJMethod setter = new LJMethod(
	    "set" + UString.capitalize(pname),
	    ACCESS_PUBLIC,
	    ljmodel.getType("void"),
	    new LJArgument(paramName, atype)
	);
	setter.setDescription(
	    "Sets the " + ptype.getName() + " property <b>" + pname + "</b>."
	);
	setter.setFinal(useFinal__);
	setter.setImplementation(
	    _makeSetterByArrayCode(
		pname,
		ctype,
		ptype,
		vname,
		paramName,
		propertyChange,
		vetoableChange
	    )
	);
	setter.setProperties(property.getProperties());
	ljclass.addMethod(setter);

	LJMethod setter2 = new LJMethod(
	    "set" + UString.capitalize(pname),
	    ACCESS_PUBLIC,
	    ljmodel.getType("void"),
	    new LJArgument(paramName, ptype)
	);
	setter2.setDescription(
	    "Sets the " + ptype.getName() + " property <b>" + pname + "</b>."
	);
	setter2.setFinal(useFinal__);
	setter2.setImplementation(
	    _makeSetterByArrayCodeAdapter(
		pname,
		vname,
		paramName,
		propertyChange,
		vetoableChange
	    )
	);
	setter2.setProperties(property.getProperties());
	ljclass.addMethod(setter2);

	LJMethod adder = new LJMethod(
	    "add" + UString.capitalize(pname),
	    ACCESS_PUBLIC,
	    ljmodel.getType("void"),
	    new LJArgument(paramName, ptype)
	);
	adder.setDescription(
	    "Adds the " + ptype.getName() + " property <b>" + pname + "</b>."
	);
	adder.setFinal(useFinal__);
	adder.setImplementation(
	    _makeAdderByArrayCode(
		pname,
		vname,
		paramName,
		propertyChange,
		vetoableChange
	    )
	);
	adder.setProperties(property.getProperties());
	ljclass.addMethod(adder);

	LJMethod counter = new LJMethod(
	    "get" + UString.capitalize(pname) + "Count",
	    ACCESS_PUBLIC,
	    ljmodel.getType("int")
	);
	counter.setDescription(
	    "Gets number of the " + ptype.getName() +
	    " property <b>" + pname + "</b>."
	);
	counter.setFinal(useFinal__);
	counter.setImplementation("return (" + vname + ".size());\n");
	counter.setProperties(property.getProperties());
	ljclass.addMethod(counter);

	LJMethod getIndex = new LJMethod(
	    "get" + UString.capitalize(pname),
	    ACCESS_PUBLIC,
	    ptype,
	    new LJArgument("index", ljmodel.getType("int"))
	);
	getIndex.setDescription(
	    "Gets the " + ptype.getName() +
	    " property <b>" + pname + "</b> by index."
	);
	getIndex.setFinal(useFinal__);
	getIndex.setImplementation(
	    "return ((" + ptype.getName() + ")" + vname + ".get(index));\n"
	);
	getIndex.setProperties(property.getProperties());
	ljclass.addMethod(getIndex);

	LJMethod setIndex = new LJMethod(
	    "set" + UString.capitalize(pname),
	    ACCESS_PUBLIC,
	    ljmodel.getType("void"),
	    new LJArgument("index", ljmodel.getType("int")),
	    new LJArgument(paramName, ptype)
	);
	setIndex.setDescription(
	    "Sets the " + ptype.getName() +
	    " property <b>" + pname + "</b> by index."
	);
	setIndex.setFinal(useFinal__);
	setIndex.setImplementation(
	    _makeSetterIndexByArrayCode(
		pname,
		vname,
		paramName,
		propertyChange,
		vetoableChange
	    )
	);
	setIndex.setProperties(property.getProperties());
	ljclass.addMethod(setIndex);

	LJMethod removeIndex = new LJMethod(
	    "remove" + UString.capitalize(pname),
	    ACCESS_PUBLIC,
	    ljmodel.getType("void"),
	    new LJArgument("index", ljmodel.getType("int"))
	);
	removeIndex.setDescription(
	    "Remove the " + ptype.getName() +
	    " property <b>" + pname + "</b> by index."
	);
	removeIndex.setFinal(useFinal__);
	removeIndex.setImplementation(
	    vname + ".remove(index);\n"
	);
	removeIndex.setProperties(property.getProperties());
	ljclass.addMethod(removeIndex);

	LJMethod removeObject = new LJMethod(
	    "remove" + UString.capitalize(pname),
	    ACCESS_PUBLIC,
	    ljmodel.getType("void"),
	    new LJArgument(paramName, ptype)
	);
	removeObject.setDescription(
	    "Remove the " + ptype.getName() +
	    " property <b>" + pname + "</b> by object."
	);
	removeObject.setFinal(useFinal__);
	removeObject.setImplementation(
	    "this." + vname + ".remove(" + paramName + ");\n"
	);
	removeObject.setProperties(property.getProperties());
	ljclass.addMethod(removeObject);

	LJMethod clear = new LJMethod(
	    "clear" + UString.capitalize(pname),
	    ACCESS_PUBLIC,
	    ljmodel.getType("void")
	);
	clear.setDescription(
	    "Clear the " + ptype.getName() +
	    " property <b>" + pname + "</b>."
	);
	clear.setFinal(useFinal__);
	clear.setImplementation(
	    vname + ".clear();\n"
	);
	clear.setProperties(property.getProperties());
	ljclass.addMethod(clear);
    }

    private static void _makePreBeansObject(
	String propertyName,
	String varName,
	String paramName,
	boolean propertyChange,
	boolean vetoable,
	StringBuffer buffer
    ) {
	_makePreBeansArray(
	    propertyName,
	    varName,
	    paramName,
	    propertyChange,
	    vetoable,
	    buffer
	);
    }

    private static void _makePostBeansObject(
	String propertyName,
	String varName,
	String paramName,
	boolean propertyChange,
	boolean vetoable,
	StringBuffer buffer
    ) {
	_makePostBeansArray(
	    propertyName,
	    varName,
	    paramName,
	    propertyChange,
	    vetoable,
	    buffer
	);
    }

    private static void _makePreBeansPrimitive(
	String propertyName,
	String varName,
	String paramName,
	boolean propertyChange,
	boolean vetoable,
	StringBuffer buffer
    ) {
	_makePreBeansArray(
	    propertyName,
	    varName,
	    paramName,
	    propertyChange,
	    vetoable,
	    buffer
	);
    }

    private static void _makePostBeansPrimitive(
	String propertyName,
	String varName,
	String paramName,
	boolean propertyChange,
	boolean vetoable,
	StringBuffer buffer
    ) {
	_makePostBeansArray(
	    propertyName,
	    varName,
	    paramName,
	    propertyChange,
	    vetoable,
	    buffer
	);
    }

    private static void _makePreBeansArray(
	String propertyName,
	String varName,
	String paramName,
	boolean propertyChange,
	boolean vetoable,
	StringBuffer buffer
    ) {
	if (propertyChange || vetoable) {
	    buffer.append("Object oldValue = URelaxer.getPropertyObject(\n");
	    buffer.append(varName);
	    buffer.append(");\n");
	}
	if (vetoable) {
	    buffer.append("fireVetoableChange(\"");
	    buffer.append(propertyName);
	    buffer.append("\", oldValue, \n");
	    buffer.append(paramName);
	    buffer.append(");\n");
	}
    }

    private static void _makePostBeansArray(
	String propertyName,
	String varName,
	String paramName,
	boolean propertyChange,
	boolean vetoable,
	StringBuffer buffer
    ) {
	if (propertyChange) {
	    buffer.append("firePropertyChange(\"");
	    buffer.append(propertyName);
	    buffer.append("\", oldValue, \n");
	    buffer.append(paramName);
	    buffer.append(");\n");
	}
    }

    private static String _makeGetterAsArrayCode(
	LJType ctype,
	LJType ptype,
	String name
    ) {
	String cname = ctype.getName();
	String pname = ptype.getName();
	StringBuffer buffer = new StringBuffer();
	buffer.append(pname);
	buffer.append("[] array = new ");
	buffer.append(pname);
	buffer.append("[");
	buffer.append(name);
	buffer.append(".size()];\n");
	buffer.append("return (");
	buffer.append("(");
	buffer.append(pname);
	buffer.append("[])");
	buffer.append(name);
	buffer.append(".toArray(array)");
	buffer.append(");\n");
	return (new String(buffer));
    }

    private static String _makeSetterByArrayCode(
	String propertyName,
	LJType ctype,
	LJType ptype,
	String varName,
	String paramName,
	boolean propertyChange,
	boolean vetoable
    ) {
	StringBuffer buffer = new StringBuffer();
	_makePreBeansArray(
	    propertyName,
	    varName,
	    paramName,
	    propertyChange,
	    vetoable,
	    buffer
	);
	_makeSetterByArrayCode(ctype, ptype, varName, paramName, buffer);
	_makePostBeansArray(
	    propertyName,
	    varName,
	    paramName,
	    propertyChange,
	    vetoable,
	    buffer
	);
	return (new String(buffer));
    }

    private static void _makeSetterByArrayCode(
	LJType ctype,
	LJType ptype,
	String varName,
	String paramName,
	StringBuffer buffer
    ) {
	String cname = ctype.getName();
	String pname = ptype.getName();
	buffer.append("this.");
	buffer.append(varName);
	buffer.append(".clear();\n");
	buffer.append("this.");
	buffer.append(varName);
	buffer.append(".addAll(java.util.Arrays.asList(");
	buffer.append(paramName);
	buffer.append("));\n");
    }

    private static String _makeSetterByArrayCodeAdapter(
	String propertyName,
	String varName,
	String paramName,
	boolean propertyChange,
	boolean vetoable
    ) {
	StringBuffer buffer = new StringBuffer();
	_makePreBeansArray(
	    propertyName,
	    varName,
	    paramName,
	    propertyChange,
	    vetoable,
	    buffer
	);
	buffer.append(_makeSetterByArrayCodeAdapter(varName, paramName));
	_makePostBeansArray(
	    propertyName,
	    varName,
	    paramName,
	    propertyChange,
	    vetoable,
	    buffer
	);
	return (new String(buffer));
    }

    private static String _makeSetterByArrayCodeAdapter(
	String varName,
	String paramName
    ) {
	StringBuffer buffer = new StringBuffer();
	buffer.append("this.");
	buffer.append(varName);
	buffer.append(".clear();\n");
	buffer.append("this.");
	buffer.append(varName);
	buffer.append(".add(");
	buffer.append(paramName);
	buffer.append(");\n");
	return (new String(buffer));
    }

    private static String _makeAdderByArrayCode(
	String propertyName,
	String varName,
	String paramName,
	boolean propertyChange,
	boolean vetoable
    ) {
	StringBuffer buffer = new StringBuffer();
	_makePreBeansArray(
	    propertyName,
	    varName,
	    paramName,
	    propertyChange,
	    vetoable,
	    buffer
	);
	buffer.append("this." + varName + ".add(" + paramName + ");\n");
	_makePostBeansArray(
	    propertyName,
	    varName,
	    paramName,
	    propertyChange,
	    vetoable,
	    buffer
	);
	return (new String(buffer));
    }

    private static String _makeSetterIndexByArrayCode(
	String propertyName,
	String varName,
	String paramName,
	boolean propertyChange,
	boolean vetoable
    ) {
	StringBuffer buffer = new StringBuffer();
	_makePreBeansArray(
	    propertyName,
	    varName,
	    paramName,
	    propertyChange,
	    vetoable,
	    buffer
	);
	buffer.append("this." + varName + ".set(index, " + paramName + ");\n");
	_makePostBeansArray(
	    propertyName,
	    varName,
	    paramName,
	    propertyChange,
	    vetoable,
	    buffer
	);
	return (new String(buffer));
    }

    private static void _setupPropertyPrimitive(
	BJListProperty property,
	LJClass ljclass,
	LJModel ljmodel,
	boolean propertyChange,
	boolean vetoableChange
    ) {
	String pname = property.getName();
	String vname = property.getVarName();
	String paramName = property.getParamName();
	LJType ptype = property.getType();
	LJType atype = ljmodel.getArrayType(ptype);
	LJType ctype = ljmodel.getListType(ptype);
	LJType otype = _getObjectType(ptype, ljmodel);
	LJType oatype = ljmodel.getArrayType(otype);
	LJAttribute pattr = new LJAttribute(vname, ctype, ACCESS_PRIVATE);
	ljclass.addAttribute(pattr);

	LJMethod getter = new LJMethod(
	    "get" + UString.capitalize(pname),
	    ACCESS_PUBLIC,
	    atype
	);
	getter.setDescription(
	    "Gets the " + ptype.getName() + " property <b>" + pname + "</b>."
	);
	getter.setFinal(useFinal__);
	getter.setImplementation(
	    _makeGetterAsPrimitiveArrayCode(ctype, ptype, vname)
	);
	getter.setProperties(property.getProperties());
	ljclass.addMethod(getter);

	LJMethod oGetter = new LJMethod(
	    "get" + UString.capitalize(pname) +
	    "As" + UString.capitalize(otype.getName()),
	    ACCESS_PUBLIC,
	    oatype
	);
	oGetter.setDescription(
	    "Gets the " + ptype.getName() + " property <b>" + pname + "</b>."
	);
	oGetter.setFinal(useFinal__);
	oGetter.setImplementation(
	    _makeGetterAsObjectizePrimitiveArrayCode(ctype, otype, vname)
	);
	oGetter.setProperties(property.getProperties());
	ljclass.addMethod(oGetter);

	LJMethod setter = new LJMethod(
	    "set" + UString.capitalize(pname),
	    ACCESS_PUBLIC,
	    ljmodel.getType("void"),
	    new LJArgument(paramName, atype)
	);
	setter.setDescription(
	    "Sets the " + ptype.getName() + " property <b>" + pname + "</b>."
	);
	setter.setFinal(useFinal__);
	setter.setImplementation(
	    _makeSetterByPrimitiveArrayCode(
		pname,
		ctype,
		ptype,
		vname,
		paramName,
		propertyChange,
		vetoableChange
	    )
	);
	setter.setProperties(property.getProperties());
	ljclass.addMethod(setter);

	LJMethod oSetter = new LJMethod(
	    "set" + UString.capitalize(pname),
	    ACCESS_PUBLIC,
	    ljmodel.getType("void"),
	    new LJArgument(paramName, oatype)
	);
	oSetter.setDescription(
	    "Sets the " + ptype.getName() + " property <b>" + pname + "</b>."
	);
	oSetter.setFinal(useFinal__);
	oSetter.setImplementation(
	    _makeSetterByObjectizePrimitiveArrayCode(
		pname,
		ctype,
		otype,
		vname,
		paramName,
		propertyChange,
		vetoableChange
	    )
	);
	oSetter.setProperties(property.getProperties());
	ljclass.addMethod(oSetter);

	LJMethod setterOne = new LJMethod(
	    "set" + UString.capitalize(pname),
	    ACCESS_PUBLIC,
	    ljmodel.getType("void"),
	    new LJArgument(paramName, ptype)
	);
	setterOne.setDescription(
	    "Sets the " + ptype.getName() + " property <b>" + pname + "</b>."
	);
	setterOne.setFinal(useFinal__);
	setterOne.setImplementation(
	    _makeSetterByPrimitiveArrayOneCode(
		pname,
		ctype,
		ptype,
		vname,
		paramName,
		propertyChange,
		vetoableChange
	    )
	);
	setterOne.setProperties(property.getProperties());
	ljclass.addMethod(setterOne);

	LJMethod oSetterOne = new LJMethod(
	    "set" + UString.capitalize(pname),
	    ACCESS_PUBLIC,
	    ljmodel.getType("void"),
	    new LJArgument(paramName, otype)
	);
	oSetterOne.setDescription(
	    "Sets the " + ptype.getName() + " property <b>" + pname + "</b>."
	);
	oSetterOne.setFinal(useFinal__);
	oSetterOne.setImplementation(
	    _makeSetterByObjectizePrimitiveArrayOneCode(
		pname,
		ctype,
		otype,
		vname,
		paramName,
		propertyChange,
		vetoableChange
	    )
	);
	oSetterOne.setProperties(property.getProperties());
	ljclass.addMethod(oSetterOne);

	LJMethod adder = new LJMethod(
	    "add" + UString.capitalize(pname),
	    ACCESS_PUBLIC,
	    ljmodel.getType("void"),
	    new LJArgument(paramName, ptype)
	);
	adder.setDescription(
	    "Adds the " + ptype.getName() + " property <b>" + pname + "</b>."
	);
	adder.setFinal(useFinal__);
	adder.setImplementation(
	    _makeAdderByPrimitiveArrayCode(
		pname,
		ctype,
		ptype,
		vname,
		paramName,
		propertyChange,
		vetoableChange
	    )
	);
	adder.setProperties(property.getProperties());
	ljclass.addMethod(adder);

	LJMethod oAdder = new LJMethod(
	    "add" + UString.capitalize(pname),
	    ACCESS_PUBLIC,
	    ljmodel.getType("void"),
	    new LJArgument(paramName, otype)
	);
	oAdder.setDescription(
	    "Adds the " + ptype.getName() + " property <b>" + pname + "</b>."
	);
	oAdder.setFinal(useFinal__);
	oAdder.setImplementation(
	    _makeAdderByObjectizePrimitiveArrayCode(
		pname,
		ctype,
		otype,
		vname,
		paramName,
		propertyChange,
		vetoableChange
	    )
	);
	oAdder.setProperties(property.getProperties());
	ljclass.addMethod(oAdder);

	LJMethod counter = new LJMethod(
	    "get" + UString.capitalize(pname) + "Count",
	    ACCESS_PUBLIC,
	    ljmodel.getType("int")
	);
	counter.setDescription(
	    "Gets number of the " + ptype.getName() +
	    " property <b>" + pname + "</b>."
	);
	counter.setFinal(useFinal__);
	counter.setImplementation("@return (" + vname + ".size());\n");
	counter.setProperties(property.getProperties());
	ljclass.addMethod(counter);

	LJMethod getIndex = new LJMethod(
	    "get" + UString.capitalize(pname),
	    ACCESS_PUBLIC,
	    ptype,
	    new LJArgument("index", ljmodel.getType("int"))
	);
	getIndex.setDescription(
	    "Gets the " + ptype.getName() +
	    " property <b>" + pname + "</b> by index."
	);
	getIndex.setFinal(useFinal__);
	getIndex.setImplementation(
	    _makeGetIndexAsPrimitive(ctype, ptype, vname)
	);
	getIndex.setProperties(property.getProperties());
	ljclass.addMethod(getIndex);

	LJMethod oGetIndex = new LJMethod(
	    "get" + UString.capitalize(pname) +
	    "As" + otype.getName(),
	    ACCESS_PUBLIC,
	    otype,
	    new LJArgument("index", ljmodel.getType("int"))
	);
	oGetIndex.setDescription(
	    "Gets the " + ptype.getName() +
	    " property <b>" + pname + "</b> by index."
	);
	oGetIndex.setFinal(useFinal__);
	oGetIndex.setImplementation(
	    _makeGetIndexAsObjectizePrimitive(ctype, otype, vname)
	);
	oGetIndex.setProperties(property.getProperties());
	ljclass.addMethod(oGetIndex);

	LJMethod setIndex = new LJMethod(
	    "set" + UString.capitalize(pname),
	    ACCESS_PUBLIC,
	    ljmodel.getType("void"),
	    new LJArgument("index", ljmodel.getType("int")),
	    new LJArgument(paramName, ptype)
	);
	setIndex.setDescription(
	    "Sets the " + ptype.getName() +
	    " property <b>" + pname + "</b> by index."
	);
	setIndex.setFinal(useFinal__);
	setIndex.setImplementation(
	    _makeSetIndexByPrimitive(
		pname,
		ctype,
		ptype,
		vname,
		paramName,
		propertyChange,
		vetoableChange
	    )
	);
	setIndex.setProperties(property.getProperties());
	ljclass.addMethod(setIndex);

	LJMethod oSetIndex = new LJMethod(
	    "set" + UString.capitalize(pname),
	    ACCESS_PUBLIC,
	    ljmodel.getType("void"),
	    new LJArgument("index", ljmodel.getType("int")),
	    new LJArgument(paramName, otype)
	);
	oSetIndex.setDescription(
	    "Sets the " + ptype.getName() +
	    " property <b>" + pname + "</b> by index."
	);
	oSetIndex.setFinal(useFinal__);
	oSetIndex.setImplementation(
	    _makeSetIndexByObjectizePrimitive(
		pname,
		ctype,
		otype,
		vname,
		paramName,
		propertyChange,
		vetoableChange
	    )
	);
	oSetIndex.setProperties(property.getProperties());
	ljclass.addMethod(oSetIndex);

	LJMethod removeIndex = new LJMethod(
	    "remove" + UString.capitalize(pname),
	    ACCESS_PUBLIC,
	    ljmodel.getType("void"),
	    new LJArgument("index", ljmodel.getType("int"))
	);
	removeIndex.setDescription(
	    "Remove the " + ptype.getName() +
	    " property <b>" + pname + "</b> by index."
	);
	removeIndex.setFinal(useFinal__);
	removeIndex.setImplementation(
	    vname + ".remove(index);\n"
	);
	removeIndex.setProperties(property.getProperties());
	ljclass.addMethod(removeIndex);

	LJMethod removeValue = new LJMethod(
	    "remove" + UString.capitalize(pname),
	    ACCESS_PUBLIC,
	    ljmodel.getType("void"),
	    new LJArgument(paramName, otype)
	);
	removeValue.setDescription(
	    "Remove the " + ptype.getName() +
	    " property <b>" + pname + "</b> by value."
	);
	removeValue.setFinal(useFinal__);
	removeValue.setImplementation(
	    vname + ".remove(" +
	    _getCreateObjectByValue(ptype, paramName) + ");\n"
	);
	removeValue.setProperties(property.getProperties());
	ljclass.addMethod(removeValue);

	LJMethod removeObject = new LJMethod(
	    "remove" + UString.capitalize(pname),
	    ACCESS_PUBLIC,
	    ljmodel.getType("void"),
	    new LJArgument(paramName, otype)
	);
	removeObject.setDescription(
	    "Remove the " + ptype.getName() +
	    " property <b>" + pname + "</b> by object."
	);
	removeObject.setFinal(useFinal__);
	removeObject.setImplementation(
	    vname + ".remove(" + paramName + ");\n"
	);
	removeObject.setProperties(property.getProperties());
	ljclass.addMethod(removeObject);

	LJMethod clear = new LJMethod(
	    "clear" + UString.capitalize(pname),
	    ACCESS_PUBLIC,
	    ljmodel.getType("void")
	);
	clear.setDescription(
	    "Clear the " + ptype.getName() +
	    " property <b>" + pname + "</b>."
	);
	clear.setFinal(useFinal__);
	clear.setImplementation(
	    vname + ".clear();\n"
	);
	clear.setProperties(property.getProperties());
	ljclass.addMethod(clear);
    }

    private static String _makeGetterAsPrimitiveArrayCode(
	LJType ctype,
	LJType ptype,
	String name
    ) {
	String cname = ctype.getName();
	String pname = ptype.getName();
	StringBuffer buffer = new StringBuffer();
	buffer.append(pname);
	buffer.append("[] array = new ");
	buffer.append(pname);
	buffer.append("[");
	buffer.append(name);
	buffer.append(".size()];\n");
	if ("boolean".equals(pname)) {
	    buffer.append("for (int i = 0;i < array.length;i++) {\n");
	    buffer.append("@array[i] = ((Boolean)");
	    buffer.append(name);
	    buffer.append(".get(i)).booleanValue();\n");
	    buffer.append("}\n");
	} else if ("byte".equals(pname)) {
	    buffer.append("for (int i = 0;i < array.length;i++) {\n");
	    buffer.append("@array[i] = ((Byte)");
	    buffer.append(name);
	    buffer.append(".get(i)).byteValue();\n");
	    buffer.append("}\n");
	} else if ("short".equals(pname)) {
	    buffer.append("for (int i = 0;i < array.length;i++) {\n");
	    buffer.append("@array[i] = ((Short)");
	    buffer.append(name);
	    buffer.append(".get(i)).shortValue();\n");
	    buffer.append("}\n");
	} else if ("int".equals(pname)) {
	    buffer.append("for (int i = 0;i < array.length;i++) {\n");
	    buffer.append("@array[i] = ((Integer)");
	    buffer.append(name);
	    buffer.append(".get(i)).intValue();\n");
	    buffer.append("}\n");
	} else if ("long".equals(pname)) {
	    buffer.append("for (int i = 0;i < array.length;i++) {\n");
	    buffer.append("@array[i] = ((Long)");
	    buffer.append(name);
	    buffer.append(".get(i)).longValue();\n");
	    buffer.append("}\n");
	} else if ("float".equals(pname)) {
	    buffer.append("for (int i = 0;i < array.length;i++) {\n");
	    buffer.append("@array[i] = ((Float)");
	    buffer.append(name);
	    buffer.append(".get(i)).floatValue();\n");
	    buffer.append("}\n");
	} else if ("double".equals(pname)) {
	    buffer.append("for (int i = 0;i < array.length;i++) {\n");
	    buffer.append("@array[i] = ((Double)");
	    buffer.append(name);
	    buffer.append(".get(i)).doubleValue();\n");
	    buffer.append("}\n");
	} else {
	    throw (new InternalError());
	}
	buffer.append("return (array);\n");
	return (new String(buffer));
    }

    private static String _makeGetterAsObjectizePrimitiveArrayCode(
	LJType ctype,
	LJType ptype,
	String name
    ) {
	String cname = ctype.getName();
	String pname = ptype.getName();
	StringBuffer buffer = new StringBuffer();
	buffer.append(pname);
	buffer.append("[] array = new ");
	buffer.append(pname);
	buffer.append("[");
	buffer.append(name);
	buffer.append(".size()];\n");
	buffer.append("return ((");
	buffer.append(pname);
	buffer.append("[])");
	buffer.append(name);
	buffer.append(".toArray(array));\n");
	return (new String(buffer));
    }

    private static String _makeSetterByPrimitiveArrayCode(
	String propertyName,
	LJType ctype,
	LJType ptype,
	String varName,
	String paramName,
	boolean propertyChange,
	boolean vetoable
    ) {
	StringBuffer buffer = new StringBuffer();
	_makePreBeansArray(
	    propertyName,
	    varName,
	    paramName,
	    propertyChange,
	    vetoable,
	    buffer
	);
	buffer.append(
	    _makeSetterByPrimitiveArrayCode(ctype, ptype, varName, paramName)
	);
	_makePostBeansArray(
	    propertyName,
	    varName,
	    paramName,
	    propertyChange,
	    vetoable,
	    buffer
	);
	return (new String(buffer));
    }

    private static String _makeSetterByPrimitiveArrayCode(
	LJType ctype,
	LJType ptype,
	String varName,
	String paramName
    ) {
	String cname = ctype.getName();
	String pname = ptype.getName();
	StringBuffer buffer = new StringBuffer();
	buffer.append("this.");
	buffer.append(varName);
	buffer.append(".clear();\n");
	if ("boolean".equals(pname)) {
	    buffer.append("for (int i = 0;i < ");
	    buffer.append(paramName);
	    buffer.append(".length;i++) {\n");
	    buffer.append("@this.");
	    buffer.append(varName);
	    buffer.append(".add(new Boolean(");
	    buffer.append(paramName);
	    buffer.append("[i])));\n");
	    buffer.append("}\n");
	} else if ("byte".equals(pname)) {
	    buffer.append("for (int i = 0;i < ");
	    buffer.append(paramName);
	    buffer.append(".length;i++) {\n");
	    buffer.append("@this.");
	    buffer.append(varName);
	    buffer.append(".add(new Byte(");
	    buffer.append(paramName);
	    buffer.append("[i]));\n");
	    buffer.append("}\n");
	} else if ("short".equals(pname)) {
	    buffer.append("for (int i = 0;i < ");
	    buffer.append(paramName);
	    buffer.append(".length;i++) {\n");
	    buffer.append("@this.");
	    buffer.append(varName);
	    buffer.append(".add(new Short(");
	    buffer.append(paramName);
	    buffer.append("[i]));\n");
	    buffer.append("}\n");
	} else if ("int".equals(pname)) {
	    buffer.append("for (int i = 0;i < ");
	    buffer.append(paramName);
	    buffer.append(".length;i++) {\n");
	    buffer.append("@this.");
	    buffer.append(varName);
	    buffer.append(".add(new Integer(");
	    buffer.append(paramName);
	    buffer.append("[i]));\n");
	    buffer.append("}\n");
	} else if ("long".equals(pname)) {
	    buffer.append("for (int i = 0;i < ");
	    buffer.append(paramName);
	    buffer.append(".length;i++) {\n");
	    buffer.append("@this.");
	    buffer.append(varName);
	    buffer.append(".add(new Long(");
	    buffer.append(paramName);
	    buffer.append("[i]));\n");
	    buffer.append("}\n");
	} else if ("float".equals(pname)) {
	    buffer.append("for (int i = 0;i < ");
	    buffer.append(paramName);
	    buffer.append(".length;i++) {\n");
	    buffer.append("@this.");
	    buffer.append(varName);
	    buffer.append(".add(new Float(");
	    buffer.append(paramName);
	    buffer.append("[i]));\n");
	    buffer.append("}\n");
	} else if ("double".equals(pname)) {
	    buffer.append("for (int i = 0;i < ");
	    buffer.append(paramName);
	    buffer.append(".length;i++) {\n");
	    buffer.append("@this.");
	    buffer.append(varName);
	    buffer.append(".add(new Double(");
	    buffer.append(paramName);
	    buffer.append("[i]));\n");
	    buffer.append("}\n");
	} else {
	    throw (new InternalError());
	}
	return (new String(buffer));
    }

    private static String _makeSetterByObjectizePrimitiveArrayCode(
	String propertyName,
	LJType ctype,
	LJType ptype,
	String varName,
	String paramName,
	boolean propertyChange,
	boolean vetoableChange
    ) {
	StringBuffer buffer = new StringBuffer();
	_makePreBeansPrimitive(
	    propertyName,
	    varName,
	    paramName,
	    propertyChange,
	    vetoableChange,
	    buffer
	);
	buffer.append(
	    _makeSetterByObjectizePrimitiveArrayCode(
		ctype,
		ptype,
		varName,
		paramName
	    )
	);
	_makePostBeansPrimitive(
	    propertyName,
	    varName,
	    paramName,
	    propertyChange,
	    vetoableChange,
	    buffer
	);
	return (new String(buffer));
    }

    private static String _makeSetterByObjectizePrimitiveArrayCode(
	LJType ctype,
	LJType ptype,
	String varName,
	String paramName
    ) {
	String cname = ctype.getName();
	String pname = ptype.getName();
	StringBuffer buffer = new StringBuffer();
	buffer.append("this.");
	buffer.append(varName);
	buffer.append(".clear();\n");
	buffer.append(varName);
	buffer.append(".addAll(java.util.Arrays.asList(");
	buffer.append(paramName);
	buffer.append("));\n");
	return (new String(buffer));
    }

    private static String _makeSetterByPrimitiveArrayOneCode(
	String propertyName,
	LJType ctype,
	LJType ptype,
	String varName,
	String paramName,
	boolean propertyChange,
	boolean vetoable
    ) {
	StringBuffer buffer = new StringBuffer();
	_makePreBeansArray(
	    propertyName,
	    varName,
	    paramName,
	    propertyChange,
	    vetoable,
	    buffer
	);
	buffer.append(
	    _makeSetterByPrimitiveArrayOneCode(ctype, ptype, varName, paramName)
	);
	_makePostBeansArray(
	    propertyName,
	    varName,
	    paramName,
	    propertyChange,
	    vetoable,
	    buffer
	);
	return (new String(buffer));
    }

    private static String _makeSetterByPrimitiveArrayOneCode(
	LJType ctype,
	LJType ptype,
	String varName,
	String paramName
    ) {
	String cname = ctype.getName();
	String pname = ptype.getName();
	StringBuffer buffer = new StringBuffer();
	buffer.append("this.");
	buffer.append(varName);
	buffer.append(".clear();\n");
	if ("boolean".equals(pname)) {
	    buffer.append("this.");
	    buffer.append(varName);
	    buffer.append(".add(new Boolean(");
	    buffer.append(paramName);
	    buffer.append("));\n");
	} else if ("byte".equals(pname)) {
	    buffer.append("this.");
	    buffer.append(varName);
	    buffer.append(".add(new Byte(");
	    buffer.append(paramName);
	    buffer.append("));\n");
	} else if ("short".equals(pname)) {
	    buffer.append("this.");
	    buffer.append(varName);
	    buffer.append(".add(new Short(");
	    buffer.append(paramName);
	    buffer.append("));\n");
	} else if ("int".equals(pname)) {
	    buffer.append("this.");
	    buffer.append(varName);
	    buffer.append(".add(new Integer(");
	    buffer.append(paramName);
	    buffer.append("));\n");
	} else if ("long".equals(pname)) {
	    buffer.append("this.");
	    buffer.append(varName);
	    buffer.append(".add(new Long(");
	    buffer.append(paramName);
	    buffer.append("));\n");
	} else if ("float".equals(pname)) {
	    buffer.append("this.");
	    buffer.append(varName);
	    buffer.append(".add(new Float(");
	    buffer.append(paramName);
	    buffer.append("));\n");
	} else if ("double".equals(pname)) {
	    buffer.append("this.");
	    buffer.append(varName);
	    buffer.append(".add(new Double(");
	    buffer.append(paramName);
	    buffer.append("));\n");
	} else {
	    throw (new InternalError());
	}
	return (new String(buffer));
    }

    private static String _makeSetterByObjectizePrimitiveArrayOneCode(
	String propertyName,
	LJType ctype,
	LJType ptype,
	String varName,
	String paramName,
	boolean propertyChange,
	boolean vetoableChange
    ) {
	StringBuffer buffer = new StringBuffer();
	_makePreBeansPrimitive(
	    propertyName,
	    varName,
	    paramName,
	    propertyChange,
	    vetoableChange,
	    buffer
	);
	buffer.append(
	    _makeSetterByObjectizePrimitiveArrayOneCode(
		ctype,
		ptype,
		varName,
		paramName
	    )
	);
	_makePostBeansPrimitive(
	    propertyName,
	    varName,
	    paramName,
	    propertyChange,
	    vetoableChange,
	    buffer
	);
	return (new String(buffer));
    }

    private static String _makeSetterByObjectizePrimitiveArrayOneCode(
	LJType ctype,
	LJType ptype,
	String varName,
	String paramName
    ) {
	String cname = ctype.getName();
	String pname = ptype.getName();
	StringBuffer buffer = new StringBuffer();
	buffer.append("this.");
	buffer.append(varName);
	buffer.append(".clear();\n");
	buffer.append(varName);
	buffer.append(".add(");
	buffer.append(paramName);
	buffer.append(");\n");
	return (new String(buffer));
    }

    private static String _makeAdderByPrimitiveArrayCode(
	String propertyName,
	LJType ctype,
	LJType ptype,
	String varName,
	String paramName,
	boolean propertyChange,
	boolean vetoableChange
    ) {
	String cname = ctype.getName();
	String pname = ptype.getName();
	StringBuffer buffer = new StringBuffer();
	_makePreBeansArray(
	    propertyName,
	    varName,
	    paramName,
	    propertyChange,
	    vetoableChange,
	    buffer
	);
	if ("boolean".equals(pname)) {
	    buffer.append("this.");
	    buffer.append(varName);
	    buffer.append(".add(new Boolean(");
	    buffer.append(paramName);
	    buffer.append("));\n");
	} else if ("byte".equals(pname)) {
	    buffer.append("this.");
	    buffer.append(varName);
	    buffer.append(".add(new Byte(");
	    buffer.append(paramName);
	    buffer.append("));\n");
	} else if ("short".equals(pname)) {
	    buffer.append("this.");
	    buffer.append(varName);
	    buffer.append(".add(new Short(");
	    buffer.append(paramName);
	    buffer.append("));\n");
	} else if ("int".equals(pname)) {
	    buffer.append("this.");
	    buffer.append(varName);
	    buffer.append(".add(new Integer(");
	    buffer.append(paramName);
	    buffer.append("));\n");
	} else if ("long".equals(pname)) {
	    buffer.append("this.");
	    buffer.append(varName);
	    buffer.append(".add(new Long(");
	    buffer.append(paramName);
	    buffer.append("));\n");
	} else if ("float".equals(pname)) {
	    buffer.append("this.");
	    buffer.append(varName);
	    buffer.append(".add(new Float(");
	    buffer.append(paramName);
	    buffer.append("));\n");
	} else if ("double".equals(pname)) {
	    buffer.append("this.");
	    buffer.append(varName);
	    buffer.append(".add(new Double(");
	    buffer.append(paramName);
	    buffer.append("));\n");
	} else {
	    throw (new InternalError());
	}
	_makePostBeansArray(
	    propertyName,
	    varName,
	    paramName,
	    propertyChange,
	    vetoableChange,
	    buffer
	);
	return (new String(buffer));
    }

    private static String _makeAdderByObjectizePrimitiveArrayCode(
	String propertyName,
	LJType ctype,
	LJType ptype,
	String varName,
	String paramName,
	boolean propertyChange,
	boolean vetoableChange
    ) {
	String cname = ctype.getName();
	String pname = ptype.getName();
	StringBuffer buffer = new StringBuffer();
	_makePreBeansArray(
	    propertyName,
	    varName,
	    paramName,
	    propertyChange,
	    vetoableChange,
	    buffer
	);
	buffer.append("this.");
	buffer.append(varName);
	buffer.append(".add(");
	buffer.append(paramName);
	buffer.append(");\n");
	_makePostBeansArray(
	    propertyName,
	    varName,
	    paramName,
	    propertyChange,
	    vetoableChange,
	    buffer
	);
	return (new String(buffer));
    }

    private static String _makeGetIndexAsPrimitive(
	LJType ctype,
	LJType ptype,
	String name
    ) {
	String cname = ctype.getName();
	String pname = ptype.getName();
	StringBuffer buffer = new StringBuffer();
	if ("boolean".equals(pname)) {
	    buffer.append("return (((Boolean)");
	    buffer.append(name);
	    buffer.append(".get(index)).booleanValue());\n");
	} else if ("byte".equals(pname)) {
	    buffer.append("return (((Byte)");
	    buffer.append(name);
	    buffer.append(".get(index)).byteValue());\n");
	} else if ("short".equals(pname)) {
	    buffer.append("return (((Short)");
	    buffer.append(name);
	    buffer.append(".get(index)).shortValue());\n");
	} else if ("int".equals(pname)) {
	    buffer.append("return (((Integer)");
	    buffer.append(name);
	    buffer.append(".get(index)).intValue());\n");
	} else if ("long".equals(pname)) {
	    buffer.append("return (((Long)");
	    buffer.append(name);
	    buffer.append(".get(index)).longValue());\n");
	} else if ("float".equals(pname)) {
	    buffer.append("return (((Float)");
	    buffer.append(name);
	    buffer.append(".get(index)).floatValue());\n");
	} else if ("double".equals(pname)) {
	    buffer.append("return (((Double)");
	    buffer.append(name);
	    buffer.append(".get(index)).doubleValue());\n");
	} else {
	    throw (new InternalError());
	}
	return (new String(buffer));
    }

    private static String _makeGetIndexAsObjectizePrimitive(
	LJType ctype,
	LJType ptype,
	String name
    ) {
	String cname = ctype.getName();
	String pname = ptype.getName();
	StringBuffer buffer = new StringBuffer();
	buffer.append("return ((");
	buffer.append(pname);
	buffer.append(")");
	buffer.append(name);
	buffer.append(".get(index));\n");
	return (new String(buffer));
    }

    private static String _makeSetIndexByPrimitive(
	String propertyName,
	LJType ctype,
	LJType ptype,
	String varName,
	String paramName,
	boolean propertyChange,
	boolean vetoableChange
    ) {
	String cname = ctype.getName();
	String pname = ptype.getName();
	StringBuffer buffer = new StringBuffer();
	_makePreBeansArray(
	    propertyName,
	    varName,
	    paramName,
	    propertyChange,
	    vetoableChange,
	    buffer
	);
	if ("boolean".equals(pname)) {
	    buffer.append("this.");
	    buffer.append(varName);
	    buffer.append(".set(index, new Boolean(");
	    buffer.append(paramName);
	    buffer.append("));\n");
	} else if ("byte".equals(pname)) {
	    buffer.append("this.");
	    buffer.append(varName);
	    buffer.append(".set(index, new Byte(");
	    buffer.append(paramName);
	    buffer.append("));\n");
	} else if ("short".equals(pname)) {
	    buffer.append("this.");
	    buffer.append(varName);
	    buffer.append(".set(index, new Short(");
	    buffer.append(paramName);
	    buffer.append("));\n");
	} else if ("int".equals(pname)) {
	    buffer.append("this.");
	    buffer.append(varName);
	    buffer.append(".set(index, new Integer(");
	    buffer.append(paramName);
	    buffer.append("));\n");
	} else if ("long".equals(pname)) {
	    buffer.append("this.");
	    buffer.append(varName);
	    buffer.append(".set(index, new Long(");
	    buffer.append(paramName);
	    buffer.append("));\n");
	} else if ("float".equals(pname)) {
	    buffer.append("this.");
	    buffer.append(varName);
	    buffer.append(".set(index, new Float(");
	    buffer.append(paramName);
	    buffer.append("));\n");
	} else if ("double".equals(pname)) {
	    buffer.append("this.");
	    buffer.append(varName);
	    buffer.append(".set(index, new Double(");
	    buffer.append(paramName);
	    buffer.append("));\n");
	} else {
	    throw (new InternalError());
	}
	_makePostBeansArray(
	    propertyName,
	    varName,
	    paramName,
	    propertyChange,
	    vetoableChange,
	    buffer
	);
	return (new String(buffer));
    }

    private static String _makeSetIndexByObjectizePrimitive(
	String propertyName,
	LJType ctype,
	LJType ptype,
	String varName,
	String paramName,
	boolean propertyChange,
	boolean vetoableChange
    ) {
	String cname = ctype.getName();
	String pname = ptype.getName();
	StringBuffer buffer = new StringBuffer();
	_makePreBeansArray(
	    propertyName,
	    varName,
	    paramName,
	    propertyChange,
	    vetoableChange,
	    buffer
	);
	buffer.append("this.");
	buffer.append(varName);
	buffer.append(".set(index, ");
	buffer.append(paramName);
	buffer.append(");\n");
	_makePostBeansArray(
	    propertyName,
	    varName,
	    paramName,
	    propertyChange,
	    vetoableChange,
	    buffer
	);
	return (new String(buffer));
    }

    public static void setupProperty(
	BJProperty property,
	LJClass ljclass,
	LJModel ljmodel,
	boolean propertyChange,
	boolean vetoableChange
    ) {
	LJType ptype = property.getType();
	if (_getObjectType(ptype.getName()) != null) { // primitive
	    if (property.isNullable()) {
		_setupPropertyNullablePrimitive(
		    property,
		    ljclass,
		    ljmodel,
		    propertyChange,
		    vetoableChange
		);
	    } else {
		_setupProperty(
		    property,
		    ljclass,
		    ljmodel,
		    propertyChange,
		    vetoableChange
		);
	    }
	} else {
	    if (property.isNullable()) {
		_setupPropertyNullable(
		    property,
		    ljclass,
		    ljmodel,
		    propertyChange,
		    vetoableChange
		);
// XXX		_setupProperty(property, ljclass, ljmodel);
	    } else {
		_setupProperty(
		    property,
		    ljclass,
		    ljmodel,
		    propertyChange,
		    vetoableChange
		);
	    }
	    if (property.isPrimitiveAccess()) {
		_setupPropertyPrimitive(
		    property,
		    ljclass,
		    ljmodel,
		    propertyChange,
		    vetoableChange
		);
	    }
	}
	_setupAltAccess(property, ljclass, ljmodel);
    }

    private static void _setupProperty(
	BJProperty property,
	LJClass ljclass,
	LJModel ljmodel,
	boolean propertyChange,
	boolean vetoableChange
    ) {
	String pname = property.getName();
	String vname = property.getVarName();
	String paramName = property.getParamName();
	LJType ptype = property.getType();
	String defaultValue = property.getDefaultValue();
	LJAttribute pattr = new LJAttribute(vname, ptype, ACCESS_PRIVATE);
	pattr.setDefaultValue(defaultValue);
	LJMethod getter = new LJMethod(
	    "get" + UString.capitalize(pname),
	    ACCESS_PUBLIC,
	    ptype
	);
	getter.setDescription(
	    "Gets the " + ptype.getName() + " property <b>" + pname + "</b>."
	);
	getter.setFinal(useFinal__);
	getter.setImplementation("return (" + vname + ");\n");
	getter.setProperties(property.getProperties());

	LJMethod setter = new LJMethod(
	    "set" + UString.capitalize(pname),
	    ACCESS_PUBLIC,
	    ljmodel.getType("void"),
	    new LJArgument(paramName, ptype)
	);
	setter.setDescription(
	    "Sets the " + ptype.getName() + " property <b>" + pname + "</b>."
	);
	setter.setFinal(useFinal__);
	setter.setImplementation(
	    _makePropertyObjectSetterImpl(
		pname,
		vname,
		paramName,
		propertyChange,
		vetoableChange
	    )
	);
	setter.setProperties(property.getProperties());

	ljclass.addAttribute(pattr);
	ljclass.addMethod(getter);
	ljclass.addMethod(setter);
    }

    private static void _setupPropertyNullable(
	BJProperty property,
	LJClass ljclass,
	LJModel ljmodel,
	boolean propertyChange,
	boolean vetoableChange
    ) {
	String pname = property.getName();
	String vname = property.getVarName();
	String paramName = property.getParamName();
	LJType ptype = property.getType();
	String defaultValue = property.getDefaultValue();
	LJAttribute pattr = new LJAttribute(vname, ptype, ACCESS_PRIVATE);
	LJMethod getter = new LJMethod(
	    "get" + UString.capitalize(pname),
	    ACCESS_PUBLIC,
	    ptype
	);
	getter.setDescription(
	    "Gets the " + ptype.getName() + " property <b>" + pname + "</b>."
	);
	getter.setFinal(useFinal__);
	if (defaultValue != null) {
	    getter.setImplementation(
		"if (" + vname + " == null) {\n" +
		"@return (" + ULJModel.makeLiteralValue(defaultValue, ptype) +
		");\n" +
		"}\n" +
		"return (" + vname + ");\n"
	    );
	} else {
	    getter.setImplementation("return (" + vname + ");\n");
	}
	getter.setProperties(property.getProperties());

	LJMethod setter = new LJMethod(
	    "set" + UString.capitalize(pname),
	    ACCESS_PUBLIC,
	    ljmodel.getType("void"),
	    new LJArgument(paramName, ptype)
	);
	setter.setDescription(
	    "Sets the " + ptype.getName() + " property <b>" + pname + "</b>."
	);
	setter.setFinal(useFinal__);
	setter.setImplementation(
	    _makePropertyObjectSetterImpl(
		pname,
		vname,
		paramName,
		propertyChange,
		vetoableChange
	    )
	);
	setter.setProperties(property.getProperties());

	ljclass.addAttribute(pattr);
	ljclass.addMethod(getter);
	ljclass.addMethod(setter);
    }

    private static void _setupPropertyPrimitive(
	BJProperty property,
	LJClass ljclass,
	LJModel ljmodel,
	boolean propertyChange,
	boolean vetoableChange
    ) {
	LJType ptype = property.getType();
	String primitiveTypeName = _getPrimitiveType(ptype.getName());
	if (primitiveTypeName == null) {
	    return;
	}
	String pname = property.getName();
	String vname = property.getVarName();
	String paramName = property.getParamName();
	LJType primitiveType = ljmodel.getType(primitiveTypeName);

	LJMethod getter = new LJMethod(
	    "get" + UString.capitalize(pname)
	    + "As" + UString.capitalize(primitiveTypeName) + "Type",
	    ACCESS_PUBLIC,
	    primitiveType
	);
	getter.setDescription(
	    "Gets the " + ptype.getName() + " property <b>" + pname + "</b>" +
	    "as" + primitiveTypeName + "."
	);
	getter.setFinal(useFinal__);
	getter.setImplementation(
	    _makePropertyPrimitiveGetterImpl(ptype, vname)
	);
	ljclass.addMethod(getter);

/*
	LJMethod oGetter = new LJMethod(
	    "get" + UString.capitalize(pname)
	    + "As" + UString.capitalize(primitiveTypeName) + "Type",
	    ACCESS_PUBLIC,
	    primitiveType
	);
	oGetter.setDescription(
	    "Gets the " + ptype.getName() + " property <b>" + pname + "</b>" +
	    "as" + primitiveTypeName + "."
	);
	oGetter.setFinal(useFinal__);
	oGetter.setImplementation(
	    _makePropertyObjectizePrimitiveGetterImpl(ptype, vname)
	);
	ljclass.addMethod(oGetter);
*/

	LJMethod setter = new LJMethod(
	    "set" + UString.capitalize(pname),
	    ACCESS_PUBLIC,
	    ljmodel.getType("void"),
	    new LJArgument(paramName, primitiveType)
	);
	setter.setDescription(
	    "Sets the " + ptype.getName() + " property <b>" + pname + "</b>."
	);
	setter.setFinal(useFinal__);
	setter.setImplementation(
	    _makePropertyPrimitiveSetterImpl(
		pname,
		ptype,
		vname,
		paramName,
		propertyChange,
		vetoableChange
	    )
	);
	ljclass.addMethod(setter);

/*
	LJMethod oSetter = new LJMethod(
	    "set" + UString.capitalize(pname),
	    ACCESS_PUBLIC,
	    ljmodel.getType("void"),
	    new LJArgument(paramName, primitiveType)
	);
	oSetter.setDescription(
	    "Sets the " + ptype.getName() + " property <b>" + pname + "</b>."
	);
	oSetter.setFinal(useFinal__);
	oSetter.setImplementation(
	    _makePropertyObjectizePrimitiveSetterImpl(ptype, vname, paramName)
	);
	ljclass.addMethod(oSetter);
*/
    }

    private static String _makePropertyPrimitiveGetterImpl(
	LJType ptype,
	String vname
    ) {
	String typeName = ptype.getName();
	if ("Boolean".equals(typeName) ||
	    "java.lang.Boolean".equals(typeName)) {

	    return (
		"if (" + vname + " == null) {\n" +
		"@return (false);\n" +
		"}\n" +
		"return (" + vname + ".booleanValue());\n"
	    );
	} else if ("Byte".equals(typeName) ||
		   "java.lang.Byte".equals(typeName)) {

	    return (
		"if (" + vname + " == null) {\n" +
		"@return ((byte)0);\n" +
		"}\n" +
		"return (" + vname + ".byteValue());\n"
	    );
	} else if ("Short".equals(typeName) ||
		   "java.lang.Short".equals(typeName)) {
	    
	    return (
		"if (" + vname + " == null) {\n" +
		"@return ((short)0);\n" +
		"}\n" +
		"return (" + vname + ".shortValue());\n"
	    );
	} else if ("Integer".equals(typeName) ||
		   "java.lang.Integer".equals(typeName)) {
	    
	    return (
		"if (" + vname + " == null) {\n" +
		"@return (0);\n" +
		"}\n" +
		"return (" + vname + ".intValue());\n"
	    );
	} else if ("Long".equals(typeName) ||
		   "java.lang.Long".equals(typeName)) {
	    
	    return (
		"if (" + vname + " == null) {\n" +
		"@return ((long)0);\n" +
		"}\n" +
		"return (" + vname + ".longValue());\n"
	    );
	} else if ("Float".equals(typeName) ||
		   "java.lang.Float".equals(typeName)) {
	    
	    return (
		"if (" + vname + " == null) {\n" +
		"@return ((float)0);\n" +
		"}\n" +
		"return (" + vname + ".floatValue());\n"
	    );
	} else if ("Double".equals(typeName) ||
		   "java.lang.Double".equals(typeName)) {
	    
	    return (
		"if (" + vname + " == null) {\n" +
		"@return ((double)0);\n" +
		"}\n" +
		"return (" + vname + ".doubleValue());\n"
	    );
	} else {
	    throw (new InternalError());
	}
    }

/*
    private static String _makePropertyObjectizePrimitiveGetterImpl(
	LJType ptype,
	String vname
    ) {
	return ("return (" + vname + ";\n");
    }
*/

    private static String _makePropertyPrimitiveSetterImpl(
	String propertyName,
	LJType ptype,
	String varName,
	String paramName,
	boolean propertyChange,
	boolean vetoableChange
    ) {
	StringBuffer buffer = new StringBuffer();
	_makePreBeansObject(
	    propertyName,
	    varName,
	    paramName,
	    propertyChange,
	    vetoableChange,
	    buffer
	);
	buffer.append(
	    _makePropertyPrimitiveSetterImpl(ptype, varName, paramName)
	);
	_makePostBeansObject(
	    propertyName,
	    varName,
	    paramName,
	    propertyChange,
	    vetoableChange,
	    buffer
	);
	return (new String(buffer));
    }

    private static String _makePropertyPrimitiveSetterImpl(
	LJType ptype,
	String varName,
	String paramName
    ) {
	String typeName = ptype.getName();
	if ("Boolean".equals(typeName) ||
	    "java.lang.Boolean".equals(typeName)) {

	    return (
		"this." + varName + " = new Boolean(" + paramName + ");\n"
	    );
	} else if ("Byte".equals(typeName) ||
		   "java.lang.Byte".equals(typeName)) {

	    return (
		"this." + varName + " = new Byte(" + paramName + ");\n"
	    );
	} else if ("Short".equals(typeName) ||
		   "java.lang.Short".equals(typeName)) {
	    
	    return (
		"this." + varName + " = new Short(" + paramName + ");\n"
	    );
	} else if ("Integer".equals(typeName) ||
		   "java.lang.Integer".equals(typeName)) {
	    
	    return (
		"this." + varName + " = new Integer(" + paramName + ");\n"
	    );
	} else if ("Long".equals(typeName) ||
		   "java.lang.Long".equals(typeName)) {
	    
	    return (
		"this." + varName + " = new Long(" + paramName + ");\n"
	    );
	} else if ("Float".equals(typeName) ||
		   "java.lang.Float".equals(typeName)) {
	    
	    return (
		"this." + varName + " = new Float(" + paramName + ");\n"
	    );
	} else if ("Double".equals(typeName) ||
		   "java.lang.Double".equals(typeName)) {
	    
	    return (
		"this." + varName + " = new Double(" + paramName + ");\n"
	    );
	} else {
	    throw (new InternalError());
	}
    }

    private static String _makePropertyObjectSetterImpl(
	String propertyName,
	String varName,
	String paramName,
	boolean propertyChange,
	boolean vetoableChange
    ) {
	StringBuffer buffer = new StringBuffer();
	_makePreBeansObject(
	    propertyName,
	    varName,
	    paramName,
	    propertyChange,
	    vetoableChange,
	    buffer
	);
	buffer.append("this." + varName + " = " + paramName + ";\n");
	_makePostBeansObject(
	    propertyName,
	    varName,
	    paramName,
	    propertyChange,
	    vetoableChange,
	    buffer
	);
	return (new String(buffer));
    }

/*
    private static String _makePropertyObjectizePrimitiveSetterImpl(
	LJType ptype,
	String varName,
	String paramName
    ) {
	return ("this." + varName + " = " + paramName + ";\n");
    }
*/

    private static void _setupPropertyNullablePrimitive(
	BJProperty property,
	LJClass ljclass,
	LJModel ljmodel,
	boolean propertyChange,
	boolean vetoableChange
    ) {
	LJType ptype = property.getType();
	LJType otype = _getObjectType(ptype, ljmodel);
	String pname = property.getName();
	String vname = property.getVarName();
	String paramName = property.getParamName();
	String defaultValue = property.getDefaultValue();
	LJAttribute pattr = new LJAttribute(vname, otype, ACCESS_PRIVATE);
	ljclass.addAttribute(pattr);

	LJMethod getter = new LJMethod(
	    "get" + UString.capitalize(pname),
	    ACCESS_PUBLIC,
	    ptype
	);
	getter.setException(ljmodel.getType("IllegalStateException"));
	getter.setDescription(
	    "Gets the " + ptype.getName() + " property <b>" + pname + "</b>."
	);
	getter.setProperties(property.getProperties());
	getter.setImplementation(
	    _makePropertyNullablePrimitiveGetterImpl(
		ptype,
		vname,
		defaultValue
	    )
	);
	ljclass.addMethod(getter);

	LJMethod oGetter = new LJMethod(
	    "get" + UString.capitalize(pname) +
	    "As" + UString.capitalize(otype.getName()),
	    ACCESS_PUBLIC,
	    otype
	);
	oGetter.setException(ljmodel.getType("IllegalStateException"));
	oGetter.setDescription(
	    "Gets the " + ptype.getName() + " property <b>" + pname + "</b>."
	);
	oGetter.setProperties(property.getProperties());
	oGetter.setImplementation(
	    _makePropertyNullableObjectizePrimitiveGetterImpl(
		ptype,
		vname,
		defaultValue
	    )
	);
	ljclass.addMethod(oGetter);

	LJMethod checker = new LJMethod(
	    "check" + UString.capitalize(pname),
	    ACCESS_PUBLIC,
	    ljmodel.getType("boolean")
	);
	checker.setDescription(
	    "Check the " + ptype.getName() + " property <b>" + pname + "</b>."
	);
	checker.setImplementation(
	    _makePropertyNullablePrimitiveCheckerImpl(ptype, vname)
	);
	ljclass.addMethod(checker);

	LJMethod setter = new LJMethod(
	    "set" + UString.capitalize(pname),
	    ACCESS_PUBLIC,
	    ljmodel.getType("void"),
	    new LJArgument(paramName, ptype)
	);
	setter.setDescription(
	    "Sets the " + ptype.getName() + " property <b>" + pname + "</b>."
	);
	setter.setProperties(property.getProperties());
	setter.setImplementation(
	    _makePropertyNullablePrimitiveSetterImpl(
		pname,
		ptype,
		vname,
		paramName,
		propertyChange,
		vetoableChange
	    )
	);
	ljclass.addMethod(setter);

	LJMethod oSetter = new LJMethod(
	    "set" + UString.capitalize(pname),
	    ACCESS_PUBLIC,
	    ljmodel.getType("void"),
	    new LJArgument(paramName, otype)
	);
	oSetter.setDescription(
	    "Sets the " + ptype.getName() + " property <b>" + pname + "</b>."
	);
	oSetter.setProperties(property.getProperties());
	oSetter.setImplementation(
	    _makePropertyNullableObjectizePrimitiveSetterImpl(
		pname,
		ptype,
		vname,
		paramName,
		propertyChange,
		vetoableChange
	    )
	);
	ljclass.addMethod(oSetter);
    }

    private static String _makePropertyNullablePrimitiveGetterImpl(
	LJType ptype,
	String vname,
	String defaultValue
    ) {
	String typeName = ptype.getName();
	StringBuffer buffer = new StringBuffer();
	buffer.append("if (");
	buffer.append(vname);
	buffer.append(" == null) {\n");
	if (defaultValue != null) {
	    buffer.append("@return(");
	    buffer.append(defaultValue);
	    buffer.append(");\n");
	} else {
	    buffer.append("@throw (new IllegalStateException(\"");
	    buffer.append(vname);
	    buffer.append("\"));\n");
	}
	buffer.append("}\n");
	if ("boolean".equals(typeName)) {
	    buffer.append("return (");
	    buffer.append(vname);
	    buffer.append(".booleanValue());\n");
	} else if ("byte".equals(typeName)) {
	    buffer.append("return (");
	    buffer.append(vname);
	    buffer.append(".byteValue());\n");
	} else if ("short".equals(typeName)) {
	    buffer.append("return (");
	    buffer.append(vname);
	    buffer.append(".shortValue());\n");
	} else if ("int".equals(typeName)) {
	    buffer.append("return (");
	    buffer.append(vname);
	    buffer.append(".intValue());\n");
	} else if ("long".equals(typeName)) {
	    buffer.append("return (");
	    buffer.append(vname);
	    buffer.append(".longValue());\n");
	} else if ("float".equals(typeName)) {
	    buffer.append("return (");
	    buffer.append(vname);
	    buffer.append(".floatValue());\n");
	} else if ("double".equals(typeName)) {
	    buffer.append("return (");
	    buffer.append(vname);
	    buffer.append(".doubleValue());\n");
	} else {
	    throw (new InternalError());
	}
	return (new String(buffer));
    }

    private static String _makePropertyNullableObjectizePrimitiveGetterImpl(
	LJType ptype,
	String vname,
	String defaultValue
    ) {
	return ("return (" + vname + ");\n");
    }

    private static String _makePropertyNullablePrimitiveCheckerImpl(
	LJType ptype,
	String vname
    ) {
	return ("return (" + vname + " != null);\n");
    }

    private static String _makePropertyNullablePrimitiveSetterImpl(
	String propertyName,
	LJType ptype,
	String varName,
	String paramName,
	boolean propertyChange,
	boolean vetoableChange
    ) {
	StringBuffer buffer = new StringBuffer();
	_makePreBeansObject(
	    propertyName,
	    varName,
	    paramName,
	    propertyChange,
	    vetoableChange,
	    buffer
	);
	buffer.append(
	    _makePropertyNullablePrimitiveSetterImpl(ptype, varName, paramName)
	);
	_makePostBeansObject(
	    propertyName,
	    varName,
	    paramName,
	    propertyChange,
	    vetoableChange,
	    buffer
	);
	return (new String(buffer));
    }

    private static String _makePropertyNullablePrimitiveSetterImpl(
	LJType ptype,
	String varName,
	String paramName
    ) {
	String typeName = ptype.getName();
	if ("boolean".equals(typeName)) {
	    return (
		"this." + varName + " = new Boolean(" + paramName + ");\n"
	    );
	} else if ("byte".equals(typeName)) {
	    return (
		"this." + varName + " = new Byte(" + paramName + ");\n"
	    );
	} else if ("short".equals(typeName)) {
	    return (
		"this." + varName + " = new Short(" + paramName + ");\n"
	    );
	} else if ("int".equals(typeName)) {
	    return (
		"this." + varName + " = new Integer(" + paramName + ");\n"
	    );
	} else if ("long".equals(typeName)) {
	    return (
		"this." + varName + " = new Long(" + paramName + ");\n"
	    );
	} else if ("float".equals(typeName)) {
	    return (
		"this." + varName + " = new Float(" + paramName + ");\n"
	    );
	} else if ("double".equals(typeName)) {
	    return (
		"this." + varName + " = new Double(" + paramName + ");\n"
	    );
	} else {
	    throw (new InternalError());
	}
    }

    private static String _makePropertyNullableObjectizePrimitiveSetterImpl(
	String propertyName,
	LJType ptype,
	String varName,
	String paramName,
	boolean propertyChange,
	boolean vetoableChange
    ) {
	StringBuffer buffer = new StringBuffer();
	_makePreBeansObject(
	    propertyName,
	    varName,
	    paramName,
	    propertyChange,
	    vetoableChange,
	    buffer
	);
	buffer.append(
	    _makePropertyNullableObjectizePrimitiveSetterImpl(
		ptype,
		varName,
		paramName
	    )
	);
	_makePostBeansObject(
	    propertyName,
	    varName,
	    paramName,
	    propertyChange,
	    vetoableChange,
	    buffer
	);
	return (new String(buffer));
    }

    private static String _makePropertyNullableObjectizePrimitiveSetterImpl(
	LJType ptype,
	String varName,
	String paramName
    ) {
	return ("this." + varName + " = " + paramName + ";\n");
    }

    public static void setupProperty(
	BJProperty property,
	LJInterface ljinterface,
	LJModel ljmodel,
	boolean propertyChange,
	boolean vetoableChange
    ) {
	LJType ptype = property.getType();
	if (_getObjectType(ptype.getName()) != null) { // primitive
	    if (property.isNullable()) {
		_setupPropertyNullablePrimitive(
		    property,
		    ljinterface,
		    ljmodel,
		    propertyChange,
		    vetoableChange
		);
	    } else {
		_setupProperty(
		    property,
		    ljinterface,
		    ljmodel,
		    propertyChange,
		    vetoableChange
		);
	    }
	} else {
	    _setupProperty(
		property,
		ljinterface,
		ljmodel,
		propertyChange,
		vetoableChange
	    );
	    if (property.isPrimitiveAccess()) {
		_setupPropertyPrimitive(
		    property,
		    ljinterface,
		    ljmodel,
		    propertyChange,
		    vetoableChange
		);
	    }
	}
    }

    private static void _setupProperty(
	BJProperty property,
	LJInterface ljinterface,
	LJModel ljmodel,
	boolean propertyChange,
	boolean vetoableChange
    ) {
	String pname = property.getName();
	String vname = property.getVarName();
	String paramName = property.getParamName();
	LJType ptype = property.getType();

	LJMethod getter = new LJMethod(
	    "get" + UString.capitalize(pname),
	    ACCESS_PUBLIC,
	    ptype
	);
	getter.setDescription(
	    "Gets the " + ptype.getName() + " property <b>" + pname + "</b>."
	);
	getter.setProperties(property.getProperties());

	LJMethod setter = new LJMethod(
	    "set" + UString.capitalize(pname),
	    ACCESS_PUBLIC,
	    ljmodel.getType("void"),
	    new LJArgument(paramName, ptype)
	);
	setter.setDescription(
	    "Sets the " + ptype.getName() + " property <b>" + pname + "</b>."
	);
	setter.setProperties(property.getProperties());

	ljinterface.addMethod(getter);
	ljinterface.addMethod(setter);
    }

    private static void _setupPropertyPrimitive(
	BJProperty property,
	LJInterface ljinterface,
	LJModel ljmodel,
	boolean propertyChange,
	boolean vetoableChange
    ) {
	LJType ptype = property.getType();
	String primitiveTypeName = _getPrimitiveType(ptype.getName());
	if (primitiveTypeName == null) {
	    return;
	}
	String pname = property.getName();
	String vname = property.getVarName();
	String paramName = property.getParamName();
	LJType primitiveType = ljmodel.getType(primitiveTypeName);

	LJMethod getter = new LJMethod(
	    "get" + UString.capitalize(pname)
	    + "As" + UString.capitalize(primitiveTypeName) + "Value",
	    ACCESS_PUBLIC,
	    primitiveType
	);
	getter.setDescription(
	    "Gets the " + ptype.getName() + " property <b>" + pname + "</b>" +
	    "as" + primitiveTypeName + "."
	);

	LJMethod setter = new LJMethod(
	    "set" + UString.capitalize(pname),
	    ACCESS_PUBLIC,
	    ljmodel.getType("void"),
	    new LJArgument(paramName, primitiveType)
	);
	setter.setDescription(
	    "Sets the " + ptype.getName() + " property <b>" + pname + "</b>."
	);

	ljinterface.addMethod(getter);
	ljinterface.addMethod(setter);
    }

    private static void _setupPropertyNullablePrimitive(
	BJProperty property,
	LJInterface ljinterface,
	LJModel ljmodel,
	boolean propertyChange,
	boolean vetoableChange
    ) {
	LJType ptype = property.getType();
	String pname = property.getName();
	String vname = property.getVarName();
	String paramName = property.getParamName();

	LJMethod getter = new LJMethod(
	    "get" + UString.capitalize(pname),
	    ACCESS_PUBLIC,
	    ptype
	);
	getter.setException(ljmodel.getType("IllegalStateException"));
	getter.setDescription(
	    "Gets the " + ptype.getName() + " property <b>" + pname + "</b>."
	);
	getter.setProperties(property.getProperties());

	LJMethod checker = new LJMethod(
	    "check" + UString.capitalize(pname),
	    ACCESS_PUBLIC,
	    ljmodel.getType("boolean")
	);
	checker.setDescription(
	    "Check the " + ptype.getName() + " property <b>" + pname + "</b>."
	);

	LJMethod setter = new LJMethod(
	    "set" + UString.capitalize(pname),
	    ACCESS_PUBLIC,
	    ljmodel.getType("void"),
	    new LJArgument(paramName, ptype)
	);
	setter.setDescription(
	    "Sets the " + ptype.getName() + " property <b>" + pname + "</b>."
	);
	setter.setProperties(property.getProperties());

	ljinterface.addMethod(getter);
	ljinterface.addMethod(checker);
	ljinterface.addMethod(setter);
    }

    private static void _setupAltAccess(
	BJProperty property,
	LJClass ljClass,
	LJModel ljModel
    ) {
	// XXX : do somework
    }

    private static LJType _getPrimitiveType(LJType type, LJModel model) {
	String name = _getPrimitiveType(type.getName());
	if (name == null) {
	    return (null);
	}
	return (model.getType(name));
    }

    private static String _getPrimitiveType(String typeName) {
	if ("Boolean".equals(typeName)) {
	    return ("boolean");
	} else if ("Byte".equals(typeName)) {
	    return ("byte");
	} else if ("Short".equals(typeName)) {
	    return ("short");
	} else if ("Integer".equals(typeName)) {
	    return ("int");
	} else if ("Long".equals(typeName)) {
	    return ("long");
	} else if ("Float".equals(typeName)) {
	    return ("float");
	} else if ("Double".equals(typeName)) {
	    return ("double");
	} else if ("java.lang.Boolean".equals(typeName)) {
	    return ("boolean");
	} else if ("java.lang.Byte".equals(typeName)) {
	    return ("byte");
	} else if ("java.lang.Short".equals(typeName)) {
	    return ("short");
	} else if ("java.lang.Integer".equals(typeName)) {
	    return ("intn");
	} else if ("java.lang.Long".equals(typeName)) {
	    return ("long");
	} else if ("java.lang.Float".equals(typeName)) {
	    return ("float");
	} else if ("java.lang.Double".equals(typeName)) {
	    return ("double");
	} else {
	    return (null);
	}
    }

    private static LJType _getObjectType(LJType type, LJModel model) {
	String name = _getObjectType(type.getName());
	if (name == null) {
	    return (null);
	}
	return (model.getType(name));
    }

    private static String _getObjectType(String typeName) {
	if ("boolean".equals(typeName)) {
	    return ("Boolean");
	} else if ("byte".equals(typeName)) {
	    return ("Byte");
	} else if ("short".equals(typeName)) {
	    return ("Short");
	} else if ("int".equals(typeName)) {
	    return ("Integer");
	} else if ("long".equals(typeName)) {
	    return ("Long");
	} else if ("float".equals(typeName)) {
	    return ("Float");
	} else if ("double".equals(typeName)) {
	    return ("Double");
	} else {
	    return (null);
	}
    }

    private static String _getCreateObjectByValue(
	LJType ptype,
	String param
    ) {
	String typeName = ptype.getName();
	if ("boolean".equals(typeName)) {
	    return ("new Boolean(" + param + ")");
	} else if ("byte".equals(typeName)) {
	    return ("new Byte(" + param + ")");
	} else if ("short".equals(typeName)) {
	    return ("new Short(" + param + ")");
	} else if ("int".equals(typeName)) {
	    return ("new Integer(" + param + ")");
	} else if ("long".equals(typeName)) {
	    return ("new Long(" + param + ")");
	} else if ("float".equals(typeName)) {
	    return ("new Float(" + param + ")");
	} else if ("double".equals(typeName)) {
	    return ("new Double(" + param + ")");
	} else {
	    throw (new InternalError(typeName));
	}
    }

    private static boolean useFinal__ = true;

    // test driver
    public static void main(String[] args) {
	LJModel ljmodel = new LJModel();
	LJType stringType = ljmodel.getType("String");
	BJBean bean = new BJBean("TestBean");
	BJProperty property = new BJProperty("name", stringType);
	bean.addProperty(property);
	LJClass ljclass = bean2class(bean, ljmodel);
	System.out.println(ULJModel.getCode(ljclass));
    }
}
