/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2002  ASAMI, Tomoharu (asami@AsamiOffice.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.jmodel.lang;

import java.util.*;
import jp.gr.java_conf.jaba2.util.ArrayMap;

/**
 * LJClass
 *
 * @since   Jan. 17, 2000
 * @version Feb. 27, 2002
 * @author  ASAMI, Tomoharu (asami@AsamiOffice.com)
 */
public class LJClass extends LJClassifier {
    private LJClass parent_;
    // List<LJInterface>
    private List implementsInterfaces_ = new ArrayList();
    // Map<MethodID, LJMethod>
    private Map classMethods_ = new ArrayMap();
    // Map<String, LJVariable>
    private Map classVariables_ = new ArrayMap();
    // Map<MethodID, LJMethod>
    private Map constructors_ = new ArrayMap();
    // Map<MethodID, LJMethod>
    private Map instanceMethods_ = new ArrayMap();
    // Map<String, LJVariable>
    private Map instanceVariables_ = new ArrayMap();
    private boolean isAbstract_ = false;

    public LJClass(String name, int access) {
	super(name, access);
    }

    public LJClass(String name, int access, LJClass original) {
	this(name, access);
	setup(original);
    }

    public final void setup(LJClass ljClass) {
	super.setup(ljClass);
	parent_ = ljClass.parent_;
	implementsInterfaces_.addAll(ljClass.implementsInterfaces_);
	classMethods_.putAll(ljClass.classMethods_);
	classVariables_.putAll(ljClass.classVariables_);
	constructors_.putAll(ljClass.constructors_);
	instanceMethods_.putAll(ljClass.instanceMethods_);
	instanceVariables_.putAll(ljClass.instanceVariables_);
/*
	System.out.println(ljClass.getName());
	System.out.println("from");
	_junk(ljClass.instanceMethods_);	
	System.out.println("to");
	_junk(instanceMethods_);	
*/
    }

/*
private void _junk(Map methods) {
    Object[] keys = methods.keySet().toArray();
    for (int i = 0;i < keys.length;i++) {
	LJMethod m = (LJMethod)methods.get(keys[i]);
	System.out.println(m.getProperties());
    }
}
*/

    public final void setAbstract(boolean isAbstract) {
	isAbstract_ = isAbstract;
    }

    public final void setParentClass(LJClass ljClass) {
	parent_ = ljClass;
    }

    public final void addImplementsInterfaces(LJInterface[] ljInterfaces) {
	implementsInterfaces_.addAll(Arrays.asList(ljInterfaces));
    }

    public final void addImplementsInterface(LJInterface ljInterface) {
	implementsInterfaces_.add(ljInterface);
    }

    public final void addClassAttribute(LJAttribute attr) {
	classVariables_.put(attr.getName(), attr);
    }

    public final void addAttribute(LJAttribute attr) {
	instanceVariables_.put(attr.getName(), attr);
    }

    public final void addConstructor(LJMethod method) {
	constructors_.put(method.getID(), method);
    }

    public final void addClassMethod(LJMethod method) {
	method.setStatic(true);
	classMethods_.put(method.getID(), method);
    }

    public final void addMethod(LJMethod method) {
	instanceMethods_.put(method.getID(), method);
    }

    public final boolean isAbstract() {
	return (isAbstract_);
    }

    public final LJClass getParentClass() {
	return (parent_);
    }

    public final boolean isImplementsInterface(LJInterface ljInterface) {
	return (implementsInterfaces_.contains(ljInterface));
    }

    public final LJInterface[] getImplementsInterfaces() {
	LJInterface[] interfaces
	    = new LJInterface[implementsInterfaces_.size()];
	return ((LJInterface[])implementsInterfaces_.toArray(interfaces));
    }

    public final LJVariable[] getClassVariables() {
	Collection values = classVariables_.values();
	LJVariable[] variables = new LJVariable[values.size()];
	return ((LJVariable[])values.toArray(variables));
    }

    public final LJVariable[] getVariables() {
	Collection values = instanceVariables_.values();
	LJVariable[] variables = new LJVariable[values.size()];
	return ((LJVariable[])values.toArray(variables));
    }

    public final LJVariable getVariable(String name) {
	LJVariable[] variables = getVariables();
	for (int i = 0;i < variables.length;i++) {
	    LJVariable variable = variables[i];
	    if (name.equals(variable.getName())) {
		return (variable);
	    }
	}
	return (null);
    }

    public final LJMethod[] getConstructors() {
	Collection values = constructors_.values();
	LJMethod[] methods = new LJMethod[values.size()];
	return ((LJMethod[])values.toArray(methods));
    }

    public final LJMethod[] getClassMethods() {
	Collection values = classMethods_.values();
	LJMethod[] methods = new LJMethod[values.size()];
	return ((LJMethod[])values.toArray(methods));
    }

    public final LJMethod[] getMethods() {
	Collection values = instanceMethods_.values();
	LJMethod[] methods = new LJMethod[values.size()];
	return ((LJMethod[])values.toArray(methods));
    }

    public final LJMethod getMethod(String name) {
	LJMethod[] methods = getMethods();
	for (int i = 0;i < methods.length;i++) {
	    LJMethod method = methods[i];
	    if (name.equals(method.getName())) {
		return (method);
	    }
	}
	return (null);
    }

    // not include static methods
    public final LJMethod[] getPublicMethods() {
	Collection values = instanceMethods_.values();
	Iterator iter = values.iterator();
	List result = new ArrayList();
	while (iter.hasNext()) {
	    LJMethod method = (LJMethod)iter.next();
	    if (method.getAccessMode() == ACCESS_PUBLIC &&
		!method.isStatic()) {

		result.add(method);
	    }
	}
	LJMethod[] array = new LJMethod[result.size()];
	return ((LJMethod[])result.toArray(array));
    }
}
