/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2000  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.jmodel.lang;

import java.util.*;
import jp.gr.java_conf.jaba2.util.ArrayMap;

/**
 * LJModel
 *
 * @since   Jan. 18, 2000
 * @version Mar.  3, 2000
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class LJModel {
    private LJPackage noPackage_ = new LJPackage();
    private Map packages_ = new ArrayMap(); // Map<String, LJPackage>

    public LJModel() {
    }

    public final void addPackage(LJPackage ljpackage) {
	packages_.put(ljpackage.getName(), ljpackage);
    }

    public final void addClass(LJClass ljclass) {
	noPackage_.addClass(ljclass);
    }

    public final void addClass(String packageName, LJClass ljclass) {
	LJPackage ljpackage = getPackage(packageName);
	if (ljpackage == null) {
	    ljpackage = new LJPackage(packageName);
	    addPackage(ljpackage);
	}
	ljpackage.addClass(ljclass);
    }

    public final void addInterface(LJInterface ljinterface) {
	noPackage_.addInterface(ljinterface);
    }

    public final void addInterface(
	String packageName,
	LJInterface ljinterface
    ) {
	LJPackage ljpackage = getPackage(packageName);
	if (ljpackage == null) {
	    ljpackage = new LJPackage(packageName);
	    addPackage(ljpackage);
	}
	ljpackage.addInterface(ljinterface);
    }

    public final LJPackage getPackage(String name) {
	return ((LJPackage)packages_.get(name));
    }

    public final LJClassifier getClassifier(String name) {
	return (null);
    }

    public final LJType getType(String name) {
	LJClassifier classifier = getClassifier(name);
	if (classifier == null) {
	    return (new LJType(name));
	}
	return (new LJType(classifier));
    }

    public final LJType getArrayType(LJType type) {
	return (new LJArrayType(type));	// XXX
    }

    public final LJType getListType(LJType type) {
	return (new LJListType(type)); // XXX
    }
}
