/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2000  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.parcel;

import java.net.URL;
import org.w3c.dom.Document;
import jp.gr.java_conf.jaba2.util.D2Array;
import jp.gr.java_conf.jaba2.io.UURL;

/**
 * UParcel
 *
 * @since   Aug. 24, 2000
 * @version Oct. 17, 2000
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public final class UParcel {
    public static IParcel makeParcel(String name, Object content) {
	if (content instanceof String) {
	    return (makeTextParcel(name, (String)content));
	} else {
	    throw (new UnsupportedOperationException());
	}
    }

    public static IParcel makeParcel(
	String name,
	Object content,
	String encoding
    ) {
	if (content instanceof String) {
	    return (makeTextParcel(name, (String)content, encoding));
	} else {
	    throw (new UnsupportedOperationException());
	}
    }

    public static IParcel makeTextParcel(String name, String text) {
	TextGadget gadget = new TextGadget();
	gadget.setName(name);
	gadget.setText(text);
	SimpleParcel parcel = new SimpleParcel();
	parcel.addGadget(gadget);
	return (parcel);
    }

    public static IParcel makeTextParcel(
	String name,
	String text,
	String encoding
    ) {
	TextGadget gadget = new TextGadget();
	gadget.setName(name);
	gadget.setText(text);
	gadget.setText(encoding);
	return (makeParcel(gadget));
    }

    public static IParcel makeDOMParcel(
	String name,
	Document doc
    ) {
	DOMGadget gadget = new DOMGadget();
	gadget.setName(name);
	gadget.setDocument(doc);
	return (makeParcel(gadget));
    }

    public static IParcel makeTableParcel(
	String name,
	D2Array table
    ) {
	TableGadget gadget = new TableGadget(table);
	gadget.setName(name);
	return (makeParcel(gadget));
    }

    public static IParcel makeLinkParcel(
	URL url
    ) {
	LinkGadget gadget = new LinkGadget(url);
	gadget.setBaseURI(UURL.getBaseURI(url));
	gadget.setName(UURL.getLastComponent(url));
	return (makeParcel(gadget));
    }

    public static IParcel makeParcel(IGadget gadget) {
	SimpleParcel parcel = new SimpleParcel();
	parcel.addGadget(gadget);
	return (parcel);
    }
}
