package jp.gr.java_conf.jaba2.util;

import java.util.Enumeration;
import java.util.Collections;
import java.util.List;
import java.util.ArrayList;
import javax.swing.tree.TreeNode;

/**
 * AbstractTreeNode
 * 
 * @since   Apr.  3, 1998
 * @version Nov. 20, 1998
 * @author  ASAMI, Tomoharu (tasami@ibm.net)
 */
public abstract class AbstractTreeNode implements TreeNode {
    protected TreeNode parent_;
    protected List children_ = new ArrayList();	// List<TreeNode>

    protected AbstractTreeNode() {
	_init(null);
    }

    protected AbstractTreeNode(TreeNode parent) {
	_init(parent);
    }

    private void _init(TreeNode parent) {
	parent_ = parent;
    }

    // TreeNode
    public TreeNode getChildAt(int childIndex) {
	return ((TreeNode)children_.get(childIndex));
    }

    // TreeNode
    public int getChildCount() {
	return (children_.size());
    }

    // TreeNode
    public TreeNode getParent() {
	return (parent_);
    }

    // TreeNode
    public int getIndex(TreeNode node) {
	return (children_.indexOf(node));
    }

    // TreeNode
    public boolean getAllowsChildren() {
	return (true);
    }

    // TreeNode
    public boolean isLeaf() {
	return (children_.size() == 0);
    }

    // TreeNode
    public Enumeration children() {
	return (Collections.enumeration(children_));
    }

    protected void addChild(TreeNode child) {
	children_.add(child);
    }
}
