/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2000  ASAMI, Tomoharu (tasami@ibm.net)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.vfs.config;

import java.net.*;
import org.w3c.dom.*;
import jp.gr.java_conf.jaba2.util.PropertyList;
import jp.gr.java_conf.jaba2.text.UString;
import jp.gr.java_conf.jaba2.xml.SmartElement;
import jp.gr.java_conf.jaba2.vfs.config.*;

/**
 * ConfigTarget
 *
 * @since   Jan. 15, 2000
 * @version Apr. 24, 2000
 * @author  ASAMI, Tomoharu (tasami@ibm.net)
 */
public class ConfigTarget {
    private URL href_;
    private PropertyList properties_ = new PropertyList();
    private ConfigList include_;
    private ConfigList exclude_;

    public ConfigTarget(Element target) {
	SmartElement se = new SmartElement(target);
	try {
	    href_ = se.getAttributeAsURLByFileOrURLName("href");
	} catch (IllegalArgumentException e) {
	    href_ = null;
	}
	Element[] properties = se.getElementsRecursive("property");
	for (int i = 0;i < properties.length;i++) {
	    Element property = properties[i];
	    String name
		= UString.checkNull(property.getAttribute("name"));
	    String value
		= UString.checkNull(property.getAttribute("value"));
	    properties_.put(name, value);
	}
	Element include = se.getOnlyElementRecursive("include");
	if (include != null) {
	    include_ = new ConfigList(include);
	}
	Element exclude = se.getOnlyElementRecursive("exclude");
	if (exclude != null) {
	    exclude_ = new ConfigList(exclude);
	}
    }

    public final  URL getHref() {
	return (href_);
    }

    public final String getProperty(String name) {
	Object value = properties_.get(name);
	if (value == null) {
	    return (null);
	} else {
	    return (value.toString());
	}
    }

    public final IConfigItem[] getIncludeItems() {
	if (include_ == null) {
	    return (null);
	}
	return (include_.getItems());
    }

    public final IConfigItem[] getExcludeItems() {
	if (exclude_ == null) {
	    return (null);
	}
	return (exclude_.getItems());
    }
}
