/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2000  ASAMI, Tomoharu (tasami@ibm.net)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.vfs.config;

import java.util.*;
import org.w3c.dom.*;
import jp.gr.java_conf.jaba2.xml.UElement;

/**
 * UConfig
 *
 * @since   Jan. 25, 2000
 * @version Jan. 26, 2000
 * @author  ASAMI, Tomoharu (tasami@ibm.net)
 */
public final class UConfig {
    public static IConfigItem[] makeItems(Element element) {
	List list = new ArrayList();
	Element[] children = UElement.getElements(element);
	for (int i = 0;i < children.length;i++) {
	    Element child = children[i];
	    String tagName = child.getTagName();
	    if ("file".equals(tagName)) {
		list.add(new ConfigFile(child));
	    } else if ("or".equals(tagName)) {
		ConfigOr or = new ConfigOr(child);
		list.add(or);
	    } else if ("and".equals(tagName)) {
		ConfigAnd and = new ConfigAnd(child);
		list.add(and);
	    } else {
		throw (new InternalError());
	    }
	}
	IConfigItem[] items = new IConfigItem[list.size()];
	return ((IConfigItem[])list.toArray(items));
    }
}
