/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2000  ASAMI, Tomoharu (tasami@ibm.net)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.vfs.ftp;

import java.util.*;
import java.io.*;
import java.net.*;
import com.oroinc.net.ftp.*;
import jp.gr.java_conf.jaba2.text.UString;
import jp.gr.java_conf.jaba2.vfs.*;

/**
 * FTPContainer
 *
 * @since   Jan. 15, 2000
 * @version Jan. 25, 2000
 * @author  ASAMI, Tomoharu (tasami@ibm.net)
 */
public class FTPContainer extends AbstractVFSContainer {
    private FTPFile dir_;
    private FTPRoot root_;

    public FTPContainer(FTPFile dir, FTPRoot root) throws IOException {
	super(UString.getLastComponent(dir.getName()));	// XXX
	dir_ = dir;
	root_ = root;
	// XXX : assume name is pathname
	FTPFile[] files = root.listFiles(dir.getName());
	if (files != null) {
	    _init(files);
	}
    }

    private void _init(FTPFile[] files) throws IOException {
	if (files == null) {
	    throw (new InternalError());
	}
	for (int i = 0;i < files.length;i++) {
	    FTPFile child = files[i];
	    if (child.isDirectory()) {
		addContainer(new FTPContainer(child, root_));
	    } else if (child.isFile()) {
		addObject(new FTPObject(child, root_));
	    } else {
		// XXX : symbolic link?
		throw (new UnsupportedOperationException());
	    }
	}
    }

    public long getModifiedTime() {
	Calendar cal = dir_.getTimestamp();
	Date date = cal.getTime();
	return (date.getTime());
    }
}
