/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2000  ASAMI, Tomoharu (tasami@ibm.net)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.vfs.ftp;

import java.util.*;
import java.io.*;
import com.oroinc.net.ftp.*;
import jp.gr.java_conf.jaba2.text.UString;
import jp.gr.java_conf.jaba2.vfs.*;

/**
 * FTPObject
 *
 * @since   Jan. 15, 2000
 * @version Jan. 25, 2000
 * @author  ASAMI, Tomoharu (tasami@ibm.net)
 */
public class FTPObject extends AbstractVFSObject {
    private FTPFile file_;
    private FTPRoot root_;

    public FTPObject(FTPFile file, FTPRoot root) {
	super(UString.getLastComponent(file.getName()));
	file_ = file;
	root_ = root;
    }

    public long getModifiedTime() {
	Calendar cal = file_.getTimestamp();
	Date date = cal.getTime();
	return (date.getTime());
    }

    public InputStream openInputStream() throws IOException {
	return (root_.openInputStream(this));
    }
}
