/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2000  ASAMI, Tomoharu (tasami@ibm.net)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.xml;

import org.w3c.dom.*;

/**
 * IDOMVisitor
 *
 * @since   Feb.  4, 2000
 * @version Feb.  4, 2000
 * @author  ASAMI, Tomoharu (tasami@ibm.net)
 */
public interface IDOMVisitor {
    void enter(Element element);
    void enter(Attr attr);
    void enter(Text text);
    void enter(CDATASection cdata);
    void enter(EntityReference entityRef);
    void enter(Entity entity);
    void enter(ProcessingInstruction pi);
    void enter(Comment comment);
    void enter(Document doc);
    void enter(DocumentType doctype);
    void enter(DocumentFragment docfrag);
    void enter(Notation notation);
    void enter(Node node);
    void visit(Element element);
    void visit(Attr attr);
    void visit(Text text);
    void visit(CDATASection cdata);
    void visit(EntityReference entityRef);
    void visit(Entity entity);
    void visit(ProcessingInstruction pi);
    void visit(Comment comment);
    void visit(Document doc);
    void visit(DocumentType doctype);
    void visit(DocumentFragment docfrag);
    void visit(Notation notation);
    void visit(Node node);
    void leave(Element element);
    void leave(Attr attr);
    void leave(Text text);
    void leave(CDATASection cdata);
    void leave(EntityReference entityRef);
    void leave(Entity entity);
    void leave(ProcessingInstruction pi);
    void leave(Comment comment);
    void leave(Document doc);
    void leave(DocumentType doctype);
    void leave(DocumentFragment docfrag);
    void leave(Notation notation);
    void leave(Node node);
}
