/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2000  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package jp.gr.java_conf.jaba2.xml;

import java.util.*;
import java.net.URL;
import org.w3c.dom.*;
import jp.gr.java_conf.jaba2.io.UURL;

/**
 * Mark2TreeVisitor
 *
 * @since   Jul. 17, 2000
 * @version Jul. 19, 2000
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class Mark2TreeVisitor extends DOMVisitorBase {
    private Document factory_;
    private List marks_ = new ArrayList();
    private Element contextElement_ = null;
    private Stack targetElementStack_ = new Stack();
    private Map targetMap_ = new HashMap();
    private Map markMap_ = new HashMap();

    public Mark2TreeVisitor(Element root, String[] marks) {
	factory_ = root.getOwnerDocument();
	contextElement_ = root;
	marks_ = Arrays.asList(marks);
    }

    public void enter(Element element) {
	String sourceTagName = element.getTagName();
	Element targetElement = (Element)_cloneNode(element);
	targetMap_.put(element, targetElement);
	MarkStack stack = _getMarkStack(element.getParentNode());
	if (stack != null) {
	    Element markContext = stack.getMark(sourceTagName);
	    if (markContext != null) {
		markContext.appendChild(targetElement);
	    } else {
		Element altContext
		    = (Element)targetMap_.get(element.getParentNode());
		altContext.appendChild(targetElement);
	    }
	} else {
	    contextElement_.appendChild(targetElement);
	}
	contextElement_ = targetElement;
	targetElementStack_.push(targetElement);
    }

    public void leave(Element element) {
	Element targetElement = (Element)targetElementStack_.pop();
	String sourceTagName = element.getTagName();
	if (_isMark(sourceTagName)) {
	    _setMarkStack(
		(Element)element.getParentNode(),
		sourceTagName,
		targetElement
	    );
	    contextElement_ = targetElement;
	} else {
	    contextElement_ = (Element)contextElement_.getParentNode();
	}
    }

    public void _enter(Node node) {
	contextElement_.appendChild(_cloneNode(node));
    }

    private boolean _isMark(String tagName) {
	return (marks_.contains(tagName));
    }

    private boolean _isStrong(String lhs, String rhs) {
	int lhsIndex = marks_.indexOf(lhs);
	int rhsIndex = marks_.indexOf(rhs);
	if (lhsIndex == -1) {
	    throw (new InternalError());
	}
	if (rhsIndex == -1) {
	    throw (new InternalError());
	}
	return (lhsIndex <= rhsIndex);
    }

    private Node _cloneNode(Node node) {
	return (UXML.makeShallowCopy(factory_, node));
    }

    private MarkStack _getMarkStack(Node context) {
	return ((MarkStack)markMap_.get(context));
    }

    private void _setMarkStack(
	Element context,
	String tagName,
	Element mark
    ) {
	MarkStack stack = _getMarkStack(context);
	if (stack == null) {
	    stack = new MarkStack();
	    markMap_.put(context, stack);
	}
	stack.setMark(tagName, mark);
    }

    class MarkStack {
	Stack stack_ = new Stack();

	void setMark(String tagName, Element mark) {
	    while (!stack_.empty()) {
		MarkInfo info = (MarkInfo)stack_.peek();
		if (!_isStrong(tagName, info.name)) {
		    break;
		}
		stack_.pop();
	    }
	    stack_.push(new MarkInfo(tagName, mark));
	}

	Element getMark(String tagName) {
	    if (!_isMark(tagName)) {
		MarkInfo info = (MarkInfo)stack_.peek();
		return (info.context);
	    }
	    while (!stack_.empty()) {
		MarkInfo info = (MarkInfo)stack_.peek();
		if (!_isStrong(tagName, info.name)) {
		    return (info.context);
		}
		stack_.pop();
	    }
	    return (null);
	}
    }

    static class MarkInfo {
	String name;
	Element context;

	MarkInfo(String name, Element context) {
	    this.name = name;
	    this.context = context;
	}
    };

    // test driver
    public static void main(String[] args) throws Exception {
	IProcessor processor = ProcessorFactory.getProcessor();
	URL url = UURL.getURLFromFileOrURLName(args[0]);
	Document source = processor.parseDocument(url);
	Document target = processor.newDocument();
	String[] marks = {"h1", "h2", "h3"};
	UTransform.mark2Tree(source, target, marks);
	System.out.println(UXML.doc2String4Print(target));
    }
}
