package jp.gr.java_conf.jaba2.xml.mathml.relaxer;

import org.w3c.dom.*;

/**
 * <b>MMtext</b> is generated by Relaxer based on MathML.rlx.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <elementRule role="mtext">
 *   <mixed>
 *     <choice occurs="*">
 *       <ref label="malignmark"/>
 *     </choice>
 *   </mixed>
 * </elementRule>
 * 
 * <tag name="mtext">
 *   <attribute name="fontsize" type="string"/>
 *   <attribute name="fontweight" type="NMTOKEN">
 *     <enumeration value="normal"/>
 *     <enumeration value="bold"/>
 *   </attribute>
 *   <attribute name="fontstyle" type="NMTOKEN">
 *     <enumeration value="normal"/>
 *     <enumeration value="italic"/>
 *   </attribute>
 *   <attribute name="fontfamily" type="string"/>
 *   <attribute name="color" type="string"/>
 *   <attribute name="class" type="string"/>
 *   <attribute name="style" type="string"/>
 *   <attribute name="id" type="ID"/>
 *   <attribute name="other" type="string"/>
 * </tag>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;elementRule role="mtext"&gt;
 *   &lt;mixed&gt;
 *     &lt;choice occurs="*"&gt;
 *       &lt;ref label="malignmark"/&gt;
 *     &lt;/choice&gt;
 *   &lt;/mixed&gt;
 * &lt;/elementRule&gt;
 * &lt;tag name="mtext"&gt;
 *   &lt;attribute name="fontsize" type="string"/&gt;
 *   &lt;attribute name="fontweight" type="NMTOKEN"&gt;
 *     &lt;enumeration value="normal"/&gt;
 *     &lt;enumeration value="bold"/&gt;
 *   &lt;/attribute&gt;
 *   &lt;attribute name="fontstyle" type="NMTOKEN"&gt;
 *     &lt;enumeration value="normal"/&gt;
 *     &lt;enumeration value="italic"/&gt;
 *   &lt;/attribute&gt;
 *   &lt;attribute name="fontfamily" type="string"/&gt;
 *   &lt;attribute name="color" type="string"/&gt;
 *   &lt;attribute name="class" type="string"/&gt;
 *   &lt;attribute name="style" type="string"/&gt;
 *   &lt;attribute name="id" type="ID"/&gt;
 *   &lt;attribute name="other" type="string"/&gt;
 * &lt;/tag&gt;
 * </pre>
 *
 * @version MathML.rlx 1.0 (Sat Sep 09 10:48:42 JST 2000)
 * @author  Relaxer 0.11b (by ASAMI@Yokohama)
 */
public class MMtext implements java.io.Serializable, IRVisitable, IRNode, IMMathContent, IMMrowContent, IMMfracContent, IMMsqrtContent, IMMrootContent, IMMstyleContent, IMMerrorContent, IMMpaddedContent, IMMphantomContent, IMMfencedContent, IMMsubContent, IMMsupContent, IMMsubsupContent, IMMunderContent, IMMoverContent, IMMunderoverContent, IMMmultiscriptsContent, IMMtableContent, IMMtrContent, IMMtdContent, IMMactionContent, IMCiPCDATA, IMCnPCDATA, IMFnContent, IMLogbaseContent, IMDegreeContent, IMBvarContent, IMUplimitContent, IMLowlimitContent, IMVectorContent, IMSetContent, IMMatrixrowContent, IMMatrixContent, IMListContent, IMIntervalContent, IMAnnotationXmlContent, IMSemanticsContent, IMDeclareContent, IMConditionContent, IMLambdaContent, IMRelnContent, IMApplyContent {
    private String fontsize;
    private String fontweight;
    private String fontstyle;
    private String fontfamily;
    private String color;
    private String classValue;
    private String style;
    private String id;
    private String other;
    // List<IMMtextPCDATA>
    private java.util.List pcdata = new java.util.ArrayList();
    private IRNode parentRNode;

    /**
     * Creates a <code>MMtext</code>.
     *
     */
    public MMtext() {
    }

    /**
     * Creates a <code>MMtext</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public MMtext(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>MMtext</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public MMtext(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>MMtext</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public MMtext(Element element) {
        setup(element);
    }

    /**
     * Sets a mixed content by <code>String</code>.
     *
     * @param text
     */
    public void setPcdata(String text) {
        setPcdata(new RString(text));
    }

    /**
     * Gets a mixed content as <code>String</code>.
     *
     * @return String
     */
    public String getPcdataAsString() {
        return (URelaxer.getStringByMixedList(pcdata));
    }

    /**
     * Initializes the <code>MMtext</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>MMtext</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>MMtext</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        setup(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        RStack stack = new RStack(element);
        fontsize = URelaxer2.getAttributePropertyAsString(element, "http://www.w3.org/1998/Math/MathML", "fontsize");
        fontweight = URelaxer2.getAttributePropertyAsString(element, "http://www.w3.org/1998/Math/MathML", "fontweight");
        fontstyle = URelaxer2.getAttributePropertyAsString(element, "http://www.w3.org/1998/Math/MathML", "fontstyle");
        fontfamily = URelaxer2.getAttributePropertyAsString(element, "http://www.w3.org/1998/Math/MathML", "fontfamily");
        color = URelaxer2.getAttributePropertyAsString(element, "http://www.w3.org/1998/Math/MathML", "color");
        classValue = URelaxer2.getAttributePropertyAsString(element, "http://www.w3.org/1998/Math/MathML", "class");
        style = URelaxer2.getAttributePropertyAsString(element, "http://www.w3.org/1998/Math/MathML", "style");
        id = URelaxer2.getAttributePropertyAsString(element, "http://www.w3.org/1998/Math/MathML", "id");
        other = URelaxer2.getAttributePropertyAsString(element, "http://www.w3.org/1998/Math/MathML", "other");
        pcdata.clear();
        while (!stack.isEmpty()) {
            if (RString.isMatch(stack)) {
                addPcdata(new RString(stack));
            } else if (MMalignmark.isMatch(stack)) {
                addPcdata(new MMalignmark(stack));
            } else {
                break;
            }
        }
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElement("mtext");
        int size;
        if (fontsize != null) {
            URelaxer2.setAttributePropertyByString(element, "http://www.w3.org/1998/Math/MathML", "fontsize", fontsize);
        }
        if (fontweight != null) {
            URelaxer2.setAttributePropertyByString(element, "http://www.w3.org/1998/Math/MathML", "fontweight", fontweight);
        }
        if (fontstyle != null) {
            URelaxer2.setAttributePropertyByString(element, "http://www.w3.org/1998/Math/MathML", "fontstyle", fontstyle);
        }
        if (fontfamily != null) {
            URelaxer2.setAttributePropertyByString(element, "http://www.w3.org/1998/Math/MathML", "fontfamily", fontfamily);
        }
        if (color != null) {
            URelaxer2.setAttributePropertyByString(element, "http://www.w3.org/1998/Math/MathML", "color", color);
        }
        if (classValue != null) {
            URelaxer2.setAttributePropertyByString(element, "http://www.w3.org/1998/Math/MathML", "class", classValue);
        }
        if (style != null) {
            URelaxer2.setAttributePropertyByString(element, "http://www.w3.org/1998/Math/MathML", "style", style);
        }
        if (id != null) {
            URelaxer2.setAttributePropertyByString(element, "http://www.w3.org/1998/Math/MathML", "id", id);
        }
        if (other != null) {
            URelaxer2.setAttributePropertyByString(element, "http://www.w3.org/1998/Math/MathML", "other", other);
        }
        size = pcdata.size();
        for (int i = 0;i < size;i++) {
            IMMtextPCDATA value = (IMMtextPCDATA)this.pcdata.get(i);
            value.makeElement(element);
        }
        parent.appendChild(element);
    }

    /**
     * Gets the String property <b>fontsize</b>.
     *
     * @return String
     */
    public final String getFontsize() {
        return (fontsize);
    }

    /**
     * Sets the String property <b>fontsize</b>.
     *
     * @param fontsize
     */
    public final void setFontsize(String fontsize) {
        this.fontsize = fontsize;
    }

    /**
     * Gets the String property <b>fontweight</b>.
     *
     * @return String
     */
    public final String getFontweight() {
        return (fontweight);
    }

    /**
     * Sets the String property <b>fontweight</b>.
     *
     * @param fontweight
     */
    public final void setFontweight(String fontweight) {
        this.fontweight = fontweight;
    }

    /**
     * Gets the String property <b>fontstyle</b>.
     *
     * @return String
     */
    public final String getFontstyle() {
        return (fontstyle);
    }

    /**
     * Sets the String property <b>fontstyle</b>.
     *
     * @param fontstyle
     */
    public final void setFontstyle(String fontstyle) {
        this.fontstyle = fontstyle;
    }

    /**
     * Gets the String property <b>fontfamily</b>.
     *
     * @return String
     */
    public final String getFontfamily() {
        return (fontfamily);
    }

    /**
     * Sets the String property <b>fontfamily</b>.
     *
     * @param fontfamily
     */
    public final void setFontfamily(String fontfamily) {
        this.fontfamily = fontfamily;
    }

    /**
     * Gets the String property <b>color</b>.
     *
     * @return String
     */
    public final String getColor() {
        return (color);
    }

    /**
     * Sets the String property <b>color</b>.
     *
     * @param color
     */
    public final void setColor(String color) {
        this.color = color;
    }

    /**
     * Gets the String property <b>classValue</b>.
     *
     * @return String
     */
    public final String getClassValue() {
        return (classValue);
    }

    /**
     * Sets the String property <b>classValue</b>.
     *
     * @param classValue
     */
    public final void setClassValue(String classValue) {
        this.classValue = classValue;
    }

    /**
     * Gets the String property <b>style</b>.
     *
     * @return String
     */
    public final String getStyle() {
        return (style);
    }

    /**
     * Sets the String property <b>style</b>.
     *
     * @param style
     */
    public final void setStyle(String style) {
        this.style = style;
    }

    /**
     * Gets the String property <b>id</b>.
     *
     * @return String
     */
    public final String getId() {
        return (id);
    }

    /**
     * Sets the String property <b>id</b>.
     *
     * @param id
     */
    public final void setId(String id) {
        this.id = id;
    }

    /**
     * Gets the String property <b>other</b>.
     *
     * @return String
     */
    public final String getOther() {
        return (other);
    }

    /**
     * Sets the String property <b>other</b>.
     *
     * @param other
     */
    public final void setOther(String other) {
        this.other = other;
    }

    /**
     * Gets the IMMtextPCDATA property <b>pcdata</b>.
     *
     * @return IMMtextPCDATA[]
     */
    public final IMMtextPCDATA[] getPcdata() {
        IMMtextPCDATA[] array = new IMMtextPCDATA[pcdata.size()];
        return ((IMMtextPCDATA[])pcdata.toArray(array));
    }

    /**
     * Sets the IMMtextPCDATA property <b>pcdata</b>.
     *
     * @param pcdata
     */
    public final void setPcdata(IMMtextPCDATA[] pcdata) {
        this.pcdata.clear();
        this.pcdata.addAll(java.util.Arrays.asList(pcdata));
        for (int i = 0;i < pcdata.length;i++) {
            pcdata[i].setParentRNode(this);
        }
    }

    /**
     * Sets the IMMtextPCDATA property <b>pcdata</b>.
     *
     * @param pcdata
     */
    public final void setPcdata(IMMtextPCDATA pcdata) {
        this.pcdata.clear();
        this.pcdata.add(pcdata);
        pcdata.setParentRNode(this);
    }

    /**
     * Adds the IMMtextPCDATA property <b>pcdata</b>.
     *
     * @param pcdata
     */
    public final void addPcdata(IMMtextPCDATA pcdata) {
        this.pcdata.add(pcdata);
        pcdata.setParentRNode(this);
    }

    /**
     * Accepts the Visitor for enter behavior.
     *
     * @param visitor
     */
    public void enter(IRVisitor visitor) {
        visitor.enter(this);
    }

    /**
     * Accepts the Visitor for leave behavior.
     *
     * @param visitor
     */
    public void leave(IRVisitor visitor) {
        visitor.leave(this);
    }

    /**
     * Gets the IRNode property <b>parentRNode</b>.
     *
     * @return IRNode
     */
    public final IRNode getParentRNode() {
        return (parentRNode);
    }

    /**
     * Sets the IRNode property <b>parentRNode</b>.
     *
     * @param parentRNode
     */
    public final void setParentRNode(IRNode parentRNode) {
        this.parentRNode = parentRNode;
    }

    /**
     * Gets child RNodes.
     *
     * @return IRNode[]
     */
    public IRNode[] getRNodes() {
        java.util.List classNodes = new java.util.ArrayList();
        classNodes.addAll(pcdata);
        IRNode[] nodes = new IRNode[classNodes.size()];
        return ((IRNode[])classNodes.toArray(nodes));
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>MMtext</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer2.isTargetElement(element, "http://www.w3.org/1998/Math/MathML", "mtext")) {
            return (false);
        }
        RStack target = new RStack(element);
        Element child;
        while (!target.isEmptyElement()) {
            if (MMalignmark.isMatchHungry(target)) {
            } else {
                break;
            }
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>MMtext</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>MMtext</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
