/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2001  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.xml.relax.cooked;

import java.util.*;
import org.w3c.dom.*;
import jp.gr.java_conf.jaba2.xml.relax.raw.*;

/**
 * CRefElementRule
 *
 * @since   Dec. 24, 1999
 * @version May. 14, 2001
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class CRefElementRule extends CElementRule {
    private String refLabel_;
    private COccurs occurs_;
    private String namespace_;

    public CRefElementRule(RElementRule rrule, RRef rref, CModule module) {
	super(rrule);
	refLabel_ = rref.getLabel();
	occurs_ = new COccurs(rref.getOccurs());
	namespace_ = rref.getNamespace();
    }

    public CRefElementRule(
	RElementRule rrule,
	RImportedLabelRef rref,
	CModule module
    ) {
	super(rrule);
	refLabel_ = rref.getLabel();
	occurs_ = new COccurs(rref.getOccurs());
    }

    public final String getRefLabel() {
	return (refLabel_);
    }

    public final COccurs getOccurs() {
	return (occurs_);
    }

    public final String getNamespace() {
	return (namespace_);
    }
}
