/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2001  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.xml.relax.expanded;

import java.util.*;
import org.w3c.dom.*;
import jp.gr.java_conf.jaba2.xml.relax.cooked.*;

/**
 * EAnyOtherElementNode
 *
 * @since   Mar. 10, 2001
 * @version Aug. 29, 2001
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class EAnyOtherElementNode extends ENode {
    private int occurs_;
    private String[] includeNamespaces_;
    private String[] excludeNamespaces_;

    public EAnyOtherElementNode(CAnyOtherElement rany) {
	super("anyOtherElement");
    }

    public EAnyOtherElementNode(EAnyOtherElementNode eany) {
	super("anyOtherElement");
    }

    public final void setOccurs(int occurs) {
	occurs_ = occurs;
    }

    public final int getOccurs() {
	return (occurs_);
    }

    public final void setIncludeNamespaces(String[] includeNamespaces) {
	includeNamespaces_ = includeNamespaces;
    }

    public final String[] getIncludeNamespaces() {
	return (includeNamespaces_);
    }

    public final void setExcludeNamespaces(String[] excludeNamespaces) {
	excludeNamespaces_ = excludeNamespaces;
    }

    public final String[] getExcludeNamespaces() {
	return (excludeNamespaces_);
    }

    public boolean enter(IEVisitor visitor) {
	return (visitor.enter(this));
    }

    public void leave(IEVisitor visitor) {
	visitor.leave(this);
    }
}
