package jp.gr.java_conf.jaba2.xml.relaxng.rRelaxng;

import java.io.*;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <b>RNInclude</b> is generated by Relaxer based on relaxNg.rxm.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <elementRule label="include">
 *   <tag name="include">
 *     <attribute name="href" type="ngToken"/>
 *   </tag>
 *   <sequence>
 *     <hedgeRef label="includeContent" occurs="*"/>
 *   </sequence>
 * </elementRule>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;elementRule label="include"&gt;
 *   &lt;tag name="include"&gt;
 *     &lt;attribute name="href" type="ngToken"/&gt;
 *   &lt;/tag&gt;
 *   &lt;sequence&gt;
 *     &lt;hedgeRef label="includeContent" occurs="*"/&gt;
 *   &lt;/sequence&gt;
 * &lt;/elementRule&gt;
 * </pre>
 *
 * @version relaxNg.rxm (Tue Jun 25 18:12:01 JST 2002)
 * @author  Relaxer 0.17b (http://www.relaxer.org)
 */
public class RNInclude implements java.io.Serializable, IRNSContainer, IRNode, IRNGrammarContentChoice {
    private RNSContext rNSContext_ = new RNSContext(this, "http://relaxng.org/ns/structure/1.0");
    private String href_;
    // List<IRNIncludeContentChoice>
    private java.util.List includeContent_ = new java.util.ArrayList();
    private Element xmlElement;
    private IRNode parentRNode_;

    /**
     * Creates a <code>RNInclude</code>.
     *
     */
    public RNInclude() {
    }

    /**
     * Creates a <code>RNInclude</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public RNInclude(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>RNInclude</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public RNInclude(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>RNInclude</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public RNInclude(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>RNInclude</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public RNInclude(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>RNInclude</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public RNInclude(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>RNInclude</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public RNInclude(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>RNInclude</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public RNInclude(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>RNInclude</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public RNInclude(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>RNInclude</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public RNInclude(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>RNInclude</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>RNInclude</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>RNInclude</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        setup(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        xmlElement = element;
        RStack stack = new RStack(element);
        rNSContext_.declareNamespace(element);
        href_ = URelaxer.getAttributePropertyAsString(element, "href");
        includeContent_.clear();
        while (!stack.isEmptyElement()) {
            if (RNDefine.isMatch(stack)) {
                addIncludeContent(new RNDefine(stack));
            } else if (RNStart.isMatch(stack)) {
                addIncludeContent(new RNStart(stack));
            } else if (RNDiv.isMatch(stack)) {
                addIncludeContent(new RNDiv(stack));
            } else {
                if (!URelaxer2.consumeElement(stack, "http://relaxng.org/ns/structure/1.0")) {
                    break;
        }
            }
        }
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElementNS("http://relaxng.org/ns/structure/1.0", "include");
        rNSContext_.setupNamespace(element);
        int size;
        if (this.href_ != null) {
            URelaxer.setAttributePropertyByString(element, "href", this.href_);
        }
        size = this.includeContent_.size();
        for (int i = 0;i < size;i++) {
            IRNIncludeContentChoice value = (IRNIncludeContentChoice)this.includeContent_.get(i);
            value.makeElement(element);
        }
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>RNInclude</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>RNInclude</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>RNInclude</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>RNInclude</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>RNInclude</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>RNInclude</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the RNSContext property <b>rNSContext</b>.
     *
     * @return RNSContext
     */
    public final RNSContext getRNSContext() {
        return (rNSContext_);
    }

    /**
     * Sets the RNSContext property <b>rNSContext</b>.
     *
     * @param rNSContext
     */
    public final void setRNSContext(RNSContext rNSContext) {
        this.rNSContext_ = rNSContext;
    }

    /**
     * Gets the String property <b>href</b>.
     *
     * @return String
     */
    public final String getHref() {
        return (href_);
    }

    /**
     * Sets the String property <b>href</b>.
     *
     * @param href
     */
    public final void setHref(String href) {
        this.href_ = href;
    }

    /**
     * Gets the IRNIncludeContentChoice property <b>includeContent</b>.
     *
     * @return IRNIncludeContentChoice[]
     */
    public final IRNIncludeContentChoice[] getIncludeContent() {
        IRNIncludeContentChoice[] array = new IRNIncludeContentChoice[includeContent_.size()];
        return ((IRNIncludeContentChoice[])includeContent_.toArray(array));
    }

    /**
     * Sets the IRNIncludeContentChoice property <b>includeContent</b>.
     *
     * @param includeContent
     */
    public final void setIncludeContent(IRNIncludeContentChoice[] includeContent) {
        this.includeContent_.clear();
        this.includeContent_.addAll(java.util.Arrays.asList(includeContent));
        for (int i = 0;i < includeContent.length;i++) {
            includeContent[i].setParentRNode(this);
        }
    }

    /**
     * Sets the IRNIncludeContentChoice property <b>includeContent</b>.
     *
     * @param includeContent
     */
    public final void setIncludeContent(IRNIncludeContentChoice includeContent) {
        this.includeContent_.clear();
        this.includeContent_.add(includeContent);
        if (includeContent != null) {
            includeContent.setParentRNode(this);
        }
    }

    /**
     * Adds the IRNIncludeContentChoice property <b>includeContent</b>.
     *
     * @param includeContent
     */
    public final void addIncludeContent(IRNIncludeContentChoice includeContent) {
        this.includeContent_.add(includeContent);
        if (includeContent != null) {
            includeContent.setParentRNode(this);
        }
    }

    /**
     * Gets number of the IRNIncludeContentChoice property <b>includeContent</b>.
     *
     * @return int
     */
    public final int getIncludeContentCount() {
        return (includeContent_.size());
    }

    /**
     * Gets the IRNIncludeContentChoice property <b>includeContent</b> by index.
     *
     * @param index
     * @return IRNIncludeContentChoice
     */
    public final IRNIncludeContentChoice getIncludeContent(int index) {
        return ((IRNIncludeContentChoice)includeContent_.get(index));
    }

    /**
     * Sets the IRNIncludeContentChoice property <b>includeContent</b> by index.
     *
     * @param index
     * @param includeContent
     */
    public final void setIncludeContent(int index, IRNIncludeContentChoice includeContent) {
        this.includeContent_.set(index, includeContent);
    }

    /**
     * Remove the IRNIncludeContentChoice property <b>includeContent</b> by index.
     *
     * @param index
     */
    public final void removeIncludeContent(int index) {
        includeContent_.remove(index);
    }

    /**
     * Remove the IRNIncludeContentChoice property <b>includeContent</b> by object.
     *
     * @param includeContent
     */
    public final void removeIncludeContent(IRNIncludeContentChoice includeContent) {
        this.includeContent_.remove(includeContent);
    }

    /**
     * Clear the IRNIncludeContentChoice property <b>includeContent</b>.
     *
     */
    public final void clearIncludeContent() {
        includeContent_.clear();
    }

    /**
     * Gets the element to use object construction.
     *
     * @return Element
     */
    public Element getXMLElement() {
        return (xmlElement);
    }

    /**
     * Makes a XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        String prefix = rNSContext_.getPrefixByUri("http://relaxng.org/ns/structure/1.0");
        buffer.append("<");
        URelaxer.makeQName(prefix, "include", buffer);
        rNSContext_.makeNSMappings(buffer);
        if (href_ != null) {
            buffer.append(" ");
            buffer.append("href");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(getHref()));
            buffer.append("\"");
        }
        buffer.append(">");
        size = this.includeContent_.size();
        for (int i = 0;i < size;i++) {
            IRNIncludeContentChoice value = (IRNIncludeContentChoice)this.includeContent_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.append("</");
        URelaxer.makeQName(prefix, "include", buffer);
        buffer.append(">");
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        String prefix = rNSContext_.getPrefixByUri("http://relaxng.org/ns/structure/1.0");
        buffer.print("<");
        URelaxer.makeQName(prefix, "include", buffer);
        rNSContext_.makeNSMappings(buffer);
        if (href_ != null) {
            buffer.print(" ");
            buffer.print("href");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(getHref()));
            buffer.print("\"");
        }
        buffer.print(">");
        size = this.includeContent_.size();
        for (int i = 0;i < size;i++) {
            IRNIncludeContentChoice value = (IRNIncludeContentChoice)this.includeContent_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.print("</");
        URelaxer.makeQName(prefix, "include", buffer);
        buffer.print(">");
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getHrefAsString() {
        return (URelaxer.getString(getHref()));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setHrefByString(String string) {
        setHref(string);
    }

    /**
     * Returns a String representation of this object.
     * While this method informs as XML format representaion, 
     *  it's purpose is just information, not making 
     * a rigid XML documentation.
     *
     * @return String
     */
    public String toString() {
        try {
            return (makeTextDocument());
        } catch (Exception e) {
            return (super.toString());
        }
    }

    /**
     * Gets the IRNode property <b>parentRNode</b>.
     *
     * @return IRNode
     */
    public final IRNode getParentRNode() {
        return (parentRNode_);
    }

    /**
     * Sets the IRNode property <b>parentRNode</b>.
     *
     * @param parentRNode
     */
    public final void setParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    /**
     * Gets child RNodes.
     *
     * @return IRNode[]
     */
    public IRNode[] getRNodes() {
        java.util.List classNodes = new java.util.ArrayList();
        classNodes.addAll(includeContent_);
        IRNode[] nodes = new IRNode[classNodes.size()];
        return ((IRNode[])classNodes.toArray(nodes));
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>RNInclude</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer2.isTargetElement(element, "http://relaxng.org/ns/structure/1.0", "include")) {
            return (false);
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        Element child;
        while (!target.isEmptyElement()) {
            if (RNDefine.isMatchHungry(target)) {
                $match$ = true;
            } else if (RNStart.isMatchHungry(target)) {
                $match$ = true;
            } else if (RNDiv.isMatchHungry(target)) {
                $match$ = true;
            } else {
                if (!URelaxer2.consumeElement(target, "http://relaxng.org/ns/structure/1.0")) {
                    break;
        }
            }
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>RNInclude</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>RNInclude</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
