package jp.gr.java_conf.jaba2.SmartDoc.normalizer.hilight;

import java.io.*;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <b>HilightData</b> is generated by Relaxer based on hilightData.rlx.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <elementRule label="hilightData">
 *   <tag/>
 *   <ref label="syntax" occurs="*"/>
 * </elementRule>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;elementRule label="hilightData"&gt;
 *   &lt;tag/&gt;
 *   &lt;ref label="syntax" occurs="*"/&gt;
 * &lt;/elementRule&gt;
 * </pre>
 *
 * @version hilightData.rlx 1.0 (Wed May 08 06:33:10 JST 2002)
 * @author  Relaxer 0.17b (http://www.relaxer.org)
 */
public class HilightData implements java.io.Serializable {
    // List<Syntax>
    private java.util.List syntax_ = new java.util.ArrayList();

    /**
     * Creates a <code>HilightData</code>.
     *
     */
    public HilightData() {
    }

    /**
     * Creates a <code>HilightData</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public HilightData(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>HilightData</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public HilightData(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>HilightData</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public HilightData(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>HilightData</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public HilightData(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>HilightData</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public HilightData(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>HilightData</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public HilightData(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>HilightData</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public HilightData(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>HilightData</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public HilightData(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>HilightData</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public HilightData(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>HilightData</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>HilightData</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>HilightData</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        setup(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        RStack stack = new RStack(element);
        syntax_.clear();
        while (!stack.isEmptyElement()) {
            if (Syntax.isMatch(stack)) {
                addSyntax(new Syntax(stack));
            } else {
                break;
            }
        }
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElement("hilightData");
        int size;
        size = this.syntax_.size();
        for (int i = 0;i < size;i++) {
            Syntax value = (Syntax)this.syntax_.get(i);
            value.makeElement(element);
        }
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>HilightData</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>HilightData</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>HilightData</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>HilightData</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>HilightData</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>HilightData</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the Syntax property <b>syntax</b>.
     *
     * @return Syntax[]
     */
    public final Syntax[] getSyntax() {
        Syntax[] array = new Syntax[syntax_.size()];
        return ((Syntax[])syntax_.toArray(array));
    }

    /**
     * Sets the Syntax property <b>syntax</b>.
     *
     * @param syntax
     */
    public final void setSyntax(Syntax[] syntax) {
        this.syntax_.clear();
        this.syntax_.addAll(java.util.Arrays.asList(syntax));
    }

    /**
     * Sets the Syntax property <b>syntax</b>.
     *
     * @param syntax
     */
    public final void setSyntax(Syntax syntax) {
        this.syntax_.clear();
        this.syntax_.add(syntax);
    }

    /**
     * Adds the Syntax property <b>syntax</b>.
     *
     * @param syntax
     */
    public final void addSyntax(Syntax syntax) {
        this.syntax_.add(syntax);
    }

    /**
     * Gets number of the Syntax property <b>syntax</b>.
     *
     * @return int
     */
    public final int getSyntaxCount() {
        return (syntax_.size());
    }

    /**
     * Gets the Syntax property <b>syntax</b> by index.
     *
     * @param index
     * @return Syntax
     */
    public final Syntax getSyntax(int index) {
        return ((Syntax)syntax_.get(index));
    }

    /**
     * Sets the Syntax property <b>syntax</b> by index.
     *
     * @param index
     * @param syntax
     */
    public final void setSyntax(int index, Syntax syntax) {
        this.syntax_.set(index, syntax);
    }

    /**
     * Remove the Syntax property <b>syntax</b> by index.
     *
     * @param index
     */
    public final void removeSyntax(int index) {
        syntax_.remove(index);
    }

    /**
     * Remove the Syntax property <b>syntax</b> by object.
     *
     * @param syntax
     */
    public final void removeSyntax(Syntax syntax) {
        this.syntax_.remove(syntax);
    }

    /**
     * Clear the Syntax property <b>syntax</b>.
     *
     */
    public final void clearSyntax() {
        syntax_.clear();
    }

    /**
     * Makes a XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        buffer.append("<hilightData");
        buffer.append(">");
        size = this.syntax_.size();
        for (int i = 0;i < size;i++) {
            Syntax value = (Syntax)this.syntax_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.append("</hilightData>");
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        buffer.print("<hilightData");
        buffer.print(">");
        size = this.syntax_.size();
        for (int i = 0;i < size;i++) {
            Syntax value = (Syntax)this.syntax_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.print("</hilightData>");
    }

    /**
     * Returns a String representation of this object.
     * While this method informs as XML format representaion, 
     *  it's purpose is just information, not making 
     * a rigid XML documentation.
     *
     * @return String
     */
    public String toString() {
        try {
            return (makeTextDocument());
        } catch (Exception e) {
            return (super.toString());
        }
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>HilightData</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "hilightData")) {
            return (false);
        }
        RStack target = new RStack(element);
        Element child;
        while (!target.isEmptyElement()) {
            if (!Syntax.isMatchHungry(target)) {
                break;
            }
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>HilightData</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>HilightData</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
