/*
 * SmartDoc : Ultimate document format based on XML
 *  Copyright (C) 1998-2000  ASAMI, Tomoharu (tasami@ibm.net)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.SmartDoc.packager;

import java.io.*;
import org.w3c.dom.*;
import jp.gr.java_conf.jaba2.j2fw.generator.*;
import jp.gr.java_conf.jaba2.xml.*;
import jp.gr.java_conf.jaba2.io.UFile;
import jp.gr.java_conf.jaba2.SmartDoc.*;

/**
 * CDFPackager
 *
 * @since   Sep.  5, 1999
 * @version Feb. 10, 2000
 * @author  ASAMI, Tomoharu (tasami@ibm.net)
 */
public class CDFPackager implements IPackager {
    public void pack(
	GeneratorArtifact[] artifacts,
	GeneratorResult result,
	String id,
	Object arg,
	File dest
    ) throws IOException {
	IProcessor processor
	    = ProcessorFactory.getProcessor();
	for (int i = 0;i < artifacts.length;i++) {
	    GeneratorArtifact artifact = artifacts[i];
	    if (artifact instanceof XMLArtifact) {
		XMLArtifact xa = (XMLArtifact)artifact;
		Document doc = processor.parseDocument(
		    new File(xa.getName()).toURL()
		);
		Element item = (Element)xa.getNode();
		Element newItem = (Element)UXML.makeCopy(doc, item);
		Element root = doc.getDocumentElement();
		UXML.updateElement(root, newItem, "HREF");
		String encoding = xa.getEncoding();
		UFile.createFile(
		    new File(xa.getName()),
		    UXML.doc2String4Print(doc, encoding),
		    encoding
		);
	    }
	}
    }
}
