package jp.gr.java_conf.jaba2.awt.explorer;

import java.util.Observable;
import javax.swing.tree.TreePath;

/**
 * AbstractExplorerModel
 *
 * @since   May. 16, 1998
 * @version Nov. 20, 1998
 * @author  ASAMI, Tomoharu (tasami@ibm.net)
 */
public abstract class AbstractExplorerModel extends Observable
    implements ExplorerModel {

    protected ShortcutListModel slmodel_ = null;
    protected IndexModel imodel_ = null;
    protected SummaryModel smodel_ = null;
    protected TreePath selection_ = null;

    // ExplorerModel
    public void setSelection(TreePath path) {
	if (path.equals(selection_)) {
	    return;
	}
	selection_ = path;
	setChanged();
	notifyObservers(path);
    }

    // ExplorerModel
    public TreePath getSelection() {
	return (selection_);
    }

    // ExplorerModel
    public void setIndexModel(IndexModel imodel) {
	imodel_ = imodel;
	addObserver(imodel_);
    }

    // ExplorerModel
    public void setSummaryModel(SummaryModel smodel) {
	smodel_ = smodel;
	addObserver(smodel_);
    }

    // ExplorerModel
    public void setShortcutListModel(ShortcutListModel slmodel) {
	slmodel_ = slmodel;
	addObserver(slmodel_);
    }

    // ExplorerModel
    public ShortcutListModel refShortcutListModel() {
	return (slmodel_);
    }

    // ExplorerModel
    public IndexModel refIndexModel() {
	return (imodel_);
    }

    // ExplorerModel
    public SummaryModel refSummaryModel() {
	return (smodel_);
    }
}
