/*
 * The JabaJaba class library
 *  Copyright (C) 1997-1999  ASAMI, Tomoharu (tasami@ibm.net)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.awt.graph;

import java.util.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import jp.gr.java_conf.jaba2.awt.*;
import jp.gr.java_conf.jaba2.awt.model.*;
import jp.gr.java_conf.jaba2.awt.graph.*;
import jp.gr.java_conf.jaba2.awt.lwlayout.*;

/**
 * GraphEditPanelDragPane
 *
 * @since   Mar.  1, 1999
 * @version Mar. 18, 1999
 * @author  ASAMI, Tomoharu (tasami@ibm.net)
 */
public class GraphEditDragPane extends CardPanel {
    protected DragPane dragPane_;
    protected RubberBandPane linkPane_;

    public GraphEditDragPane(DragModel dragModel, RubberBandModel linkModel) {
	dragPane_ = new DragPane(dragModel);
	linkPane_ = new RubberBandPane(linkModel);
	add(dragPane_, "drag");
	add(linkPane_, "link");
	raise("drag");
    }

    public void useDrag() {
	raise("drag");
    }

    public void useLink() {
	raise("link");
    }
}
