package jp.gr.java_conf.jaba2.dombus.configRelaxer;

import org.w3c.dom.*;

/**
 * <b>CPostEvent</b> is generated by Relaxer based on ConfigFile.rlx.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <elementRule label="postEvent" role="postEvent" type="emptyString"/>
 * 
 * <tag name="event" role="postEvent">
 *   <attribute name="label" required="true" type="Name"/>
 * </tag>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;elementRule label="postEvent" role="postEvent" type="emptyString"/&gt;
 * &lt;tag name="event" role="postEvent"&gt;
 *   &lt;attribute name="label" required="true" type="Name"/&gt;
 * &lt;/tag&gt;
 * </pre>
 *
 * @version ConfigFile.rlx (Tue Aug 29 11:45:15 JST 2000)
 * @author  Relaxer 0.10.2b (by ASAMI@Yokohama)
 */
public class CPostEvent implements java.io.Serializable {
    private String label;

    /**
     * Creates a <code>CPostEvent</code>.
     *
     */
    public CPostEvent() {
    }

    /**
     * Creates a <code>CPostEvent</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public CPostEvent(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>CPostEvent</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public CPostEvent(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>CPostEvent</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public CPostEvent(Element element) {
        setup(element);
    }

    /**
     * Initializes the <code>CPostEvent</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>CPostEvent</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>CPostEvent</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        setup(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        IConfigFileFactory factory = ConfigFileFactory.getFactory();
        RStack stack = new RStack(element);
        label = URelaxer.getAttributePropertyAsString(element, "label");
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElement("event");
        int size;
        URelaxer.setAttributePropertyByString(element, "label", label);
        parent.appendChild(element);
    }

    /**
     * Gets the String property <b>label</b>.
     *
     * @return String
     */
    public final String getLabel() {
        return (label);
    }

    /**
     * Sets the String property <b>label</b>.
     *
     * @param label
     */
    public final void setLabel(String label) {
        this.label = label;
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>CPostEvent</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        String tagName = element.getTagName();
        if (!"event".equals(tagName)) {
            return (false);
        }
        RStack target = new RStack(element);
        Element child;
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>CPostEvent</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>CPostEvent</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
