/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2000  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.dombus.domcomps;

import java.io.File;
import java.io.IOException;
import org.w3c.dom.*;
import jp.gr.java_conf.jaba2.io.UFile;
import jp.gr.java_conf.jaba2.dombus.*;

/**
 * DOMBusFilePackager
 *
 * @deprecated
 * @see jp.gr.java_conf.jaba2.dombus.packager.DOMBusFilePackager
 *
 * @since   Apr. 29, 2000
 * @version Aug. 25, 2000
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class DOMBusFilePackager extends AbstractDOMBusComponent {
    public boolean init() {
	return (false);
    }

    public void start() {
    }

    public Object fire(DOMBusSignal signal) {
	String urlName = (String)signal.getProperty("url");
	if (urlName == null) {
	    urlName = "output";
	}
	String encoding = (String)signal.getProperty("encoding");
	if (encoding == null) {
	    encoding = "UTF-8";
	}
	String backup = (String)signal.getProperty("backup");
	File file = new File(urlName);
	try {
	    Object content = signal.getContent();
	    if (content instanceof byte[]) {
		if ("true".equals(backup)) {
		    _backupFile(urlName);
		}
		byte[] data = (byte[])content;
		UFile.createFile(file, data);
	    } else if (content instanceof String) {
		if ("true".equals(backup)) {
		    _backupFile(urlName);
		}
		String text = (String)content;
		UFile.createFile(file, text, encoding);
	    } else if (content instanceof Document) {
		throw (new UnsupportedOperationException());
	    }
	} catch (IOException e) {
	    throw (new DOMBusException(e));
	}
	return (null);
    }

    private void _backupFile(String fileName) throws IOException {
	File file = new File(fileName);
	if (file.exists()) {
	    String backupName = fileName + ".bak";
	    File backup = new File(backupName);
	    file.renameTo(backup);
	}
    }
}
