/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2000  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package jp.gr.java_conf.jaba2.xml;

import java.util.*;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.ByteArrayOutputStream;
import java.net.URL;
import org.w3c.dom.*;
import org.xml.sax.*;
import org.apache.xerces.parsers.*;
import org.apache.xerces.dom.*;
import org.apache.xalan.xslt.*;
import org.apache.xalan.xpath.xdom.XercesLiaison;
import jp.gr.java_conf.jaba2.text.UString;
import jp.gr.java_conf.jaba2.io.UURL;
import jp.gr.java_conf.jaba2.xml.processor.XercesProcessor;

/**
 * XSLTBeans
 *
 * @since   Jul. 10, 2000
 * @version Aug. 26, 2000
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class XSLTBeans implements Cloneable, java.io.Serializable {
    private String inputURI_;
    private String inputSource_;
    private Document inputDocument_;
    private String xslURI_;
    private Document xslDocument_;
    private String encoding_;
    private Map params_ = new HashMap();

    public XSLTBeans() {
    }

    public void setInputURI(String uri) {
	inputURI_ = uri;
    }

    public String getInputURI() {
	return (inputURI_);
    }

    public final void setInputSource(String source) {
	inputSource_ = source;
    }

    public final String getInputSource() {
	return (inputSource_);
    }

    public void setInputDocument(Document doc) {
	if (doc instanceof DocumentImpl) {
	    inputDocument_ = doc;
	} else {
	    inputDocument_ = new DocumentImpl();
	    Element root = doc.getDocumentElement();
	    inputDocument_.appendChild(UXML.makeCopy(inputDocument_, root));
	}
    }

    public Document getInputDocument() {
	return (inputDocument_);
    }

    public void setXSLURI(String uri) {
	xslURI_ = uri;
    }

    public String getXSLURI() {
	return (xslURI_);
    }

    public void setStylesheetParam(String name, String value) {
	params_.put(name, value);
    }

    public Document getTargetDocument() throws SAXException, IOException {
	return (_generate());
    }

    public String getTargetDocumentAsString()
	throws SAXException, IOException {

	return (_generateString());
    }

    public String toString() {
	try {
	    return (_generateString());
	} catch (SAXException e) {
	    return ("XSLTBeans : " + e.getMessage());
	} catch (IOException e) {
	    return ("XSLTBeans : " + e.getMessage());
	}
    }

    public String getOutputEncoding() throws SAXException, IOException {
	Document doc = _getXslDocument();
	return (UXSL.getEncoding(doc));
    }

    public void setOutputEncoding(String encoding)
	throws SAXException, IOException {

	UXSL.setEncoding(_getXslDocument(), encoding);
    }

    private String _generateString() throws SAXException, IOException {
	XSLTInputSource input = new XSLTInputSource(_getInputDocument());
	Document xslDoc = _getXslDocument();
	String encoding = UXSL.getEncoding(xslDoc);
	XSLTInputSource xsl = new XSLTInputSource(xslDoc);
	ByteArrayOutputStream out = new ByteArrayOutputStream();
	XSLTResultTarget target = new XSLTResultTarget(out);
	XSLTProcessor processor = XSLTProcessorFactory.getProcessor(
	    new XercesLiaison()
	);
	_setParams(processor);
	processor.process(input, xsl, target);
	return (out.toString(encoding));
    }

    private Document _generate() throws SAXException, IOException {
	XSLTInputSource input = new XSLTInputSource(_getInputDocument());
	XSLTInputSource xsl = new XSLTInputSource(_getXslDocument());
	Document doc = new DocumentImpl();
	XSLTResultTarget target = new XSLTResultTarget(doc);
	XSLTProcessor processor = XSLTProcessorFactory.getProcessor(
	    new XercesLiaison()
	);
	_setParams(processor);
	processor.process(input, xsl, target);
	if (doc.getDocumentElement() == null) {
	    throw (new SAXException(_getInputInfo()));
	}
	return (doc);
    }

    private void _setParams(XSLTProcessor processor) {
	Set keys = params_.keySet();
	Iterator iter = keys.iterator();
	while (iter.hasNext()) {
	    String key = (String)iter.next();
	    String value = (String)params_.get(key);
	    processor.setStylesheetParam(key, value);
	}
    }

    private Document _getInputDocument()
	throws SAXException, IOException {

	Document doc = inputDocument_;
	if (doc == null) {
	    if (inputSource_ != null) {
		IProcessor processor = new XercesProcessor();
		doc = processor.parseDocumentByText(inputSource_);
	    } else if (inputURI_ != null) {
		IProcessor processor = new XercesProcessor();
		URL url = UURL.getURLFromFileOrURLName(inputURI_);
		doc = processor.parseDocument(url);
	    } else {
		throw (new IOException("no document"));
	    }
	}
	return (doc);
    }

    private Document _getXslDocument()
	throws SAXException, IOException {

	if (xslDocument_ == null) {
	    xslDocument_ = _getDocument(xslURI_);
	}
	return (xslDocument_);
    }

    private Document _getDocument(String uri)
	throws SAXException, IOException {

	DOMParser parser = new DOMParser();
	parser.parse(uri);
	return (parser.getDocument());
    }

    private String _getInputInfo() {
	if (inputURI_ != null) {
	    return (inputURI_);
	} else if (inputSource_ != null) {
	    return ("source");
	} else if (inputDocument_ != null) {
	    return ("doc");
	} else {
	    return ("unknown");
	}
    }

    // test driver
    public static void main(String[] args) throws Exception {
	String in = args[0];
	String xsl = args[1];
	XSLTBeans beans = new XSLTBeans();
	beans.setInputURI(in);
	beans.setXSLURI(xsl);
	PrintWriter out = new PrintWriter(System.out);
	out.println(beans.getTargetDocumentAsString());
	out.flush();

	out.println(beans.getTargetDocument());
	out.flush();
    }
}
