package jp.gr.java_conf.jaba2.xml.mathml.relaxer;

import org.w3c.dom.*;

/**
 * <b>MMaligngroup</b> is generated by Relaxer based on MathML.rlx.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <elementRule role="maligngroup">
 *   <empty/>
 * </elementRule>
 * 
 * <tag name="maligngroup">
 *   <attribute name="groupalign" type="string"/>
 *   <attribute name="class" type="string"/>
 *   <attribute name="style" type="string"/>
 *   <attribute name="id" type="ID"/>
 *   <attribute name="other" type="string"/>
 * </tag>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;elementRule role="maligngroup"&gt;
 *   &lt;empty/&gt;
 * &lt;/elementRule&gt;
 * &lt;tag name="maligngroup"&gt;
 *   &lt;attribute name="groupalign" type="string"/&gt;
 *   &lt;attribute name="class" type="string"/&gt;
 *   &lt;attribute name="style" type="string"/&gt;
 *   &lt;attribute name="id" type="ID"/&gt;
 *   &lt;attribute name="other" type="string"/&gt;
 * &lt;/tag&gt;
 * </pre>
 *
 * @version MathML.rlx 1.0 (Sat Sep 09 10:48:43 JST 2000)
 * @author  Relaxer 0.11b (by ASAMI@Yokohama)
 */
public class MMaligngroup implements java.io.Serializable, IRVisitable, IRNode, IMMtdContent, IMMactionContent, IMCiPCDATA, IMCnPCDATA, IMFnContent, IMLogbaseContent, IMDegreeContent, IMBvarContent, IMUplimitContent, IMLowlimitContent, IMVectorContent, IMSetContent, IMMatrixrowContent, IMMatrixContent, IMListContent, IMIntervalContent, IMAnnotationXmlContent, IMSemanticsContent, IMDeclareContent, IMConditionContent, IMLambdaContent, IMRelnContent, IMApplyContent, IMMtrContent, IMMtableContent, IMMmultiscriptsContent, IMMunderoverContent, IMMoverContent, IMMunderContent, IMMsubsupContent, IMMsupContent, IMMsubContent, IMMfencedContent, IMMphantomContent, IMMpaddedContent, IMMerrorContent, IMMstyleContent, IMMrootContent, IMMsqrtContent, IMMfracContent, IMMrowContent, IMMathContent {
    private String groupalign;
    private String classValue;
    private String style;
    private String id;
    private String other;
    private IRNode parentRNode;

    /**
     * Creates a <code>MMaligngroup</code>.
     *
     */
    public MMaligngroup() {
    }

    /**
     * Creates a <code>MMaligngroup</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public MMaligngroup(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>MMaligngroup</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public MMaligngroup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>MMaligngroup</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public MMaligngroup(Element element) {
        setup(element);
    }

    /**
     * Initializes the <code>MMaligngroup</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>MMaligngroup</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>MMaligngroup</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        setup(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        RStack stack = new RStack(element);
        groupalign = URelaxer2.getAttributePropertyAsString(element, "http://www.w3.org/1998/Math/MathML", "groupalign");
        classValue = URelaxer2.getAttributePropertyAsString(element, "http://www.w3.org/1998/Math/MathML", "class");
        style = URelaxer2.getAttributePropertyAsString(element, "http://www.w3.org/1998/Math/MathML", "style");
        id = URelaxer2.getAttributePropertyAsString(element, "http://www.w3.org/1998/Math/MathML", "id");
        other = URelaxer2.getAttributePropertyAsString(element, "http://www.w3.org/1998/Math/MathML", "other");
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElement("maligngroup");
        int size;
        if (groupalign != null) {
            URelaxer2.setAttributePropertyByString(element, "http://www.w3.org/1998/Math/MathML", "groupalign", groupalign);
        }
        if (classValue != null) {
            URelaxer2.setAttributePropertyByString(element, "http://www.w3.org/1998/Math/MathML", "class", classValue);
        }
        if (style != null) {
            URelaxer2.setAttributePropertyByString(element, "http://www.w3.org/1998/Math/MathML", "style", style);
        }
        if (id != null) {
            URelaxer2.setAttributePropertyByString(element, "http://www.w3.org/1998/Math/MathML", "id", id);
        }
        if (other != null) {
            URelaxer2.setAttributePropertyByString(element, "http://www.w3.org/1998/Math/MathML", "other", other);
        }
        parent.appendChild(element);
    }

    /**
     * Gets the String property <b>groupalign</b>.
     *
     * @return String
     */
    public final String getGroupalign() {
        return (groupalign);
    }

    /**
     * Sets the String property <b>groupalign</b>.
     *
     * @param groupalign
     */
    public final void setGroupalign(String groupalign) {
        this.groupalign = groupalign;
    }

    /**
     * Gets the String property <b>classValue</b>.
     *
     * @return String
     */
    public final String getClassValue() {
        return (classValue);
    }

    /**
     * Sets the String property <b>classValue</b>.
     *
     * @param classValue
     */
    public final void setClassValue(String classValue) {
        this.classValue = classValue;
    }

    /**
     * Gets the String property <b>style</b>.
     *
     * @return String
     */
    public final String getStyle() {
        return (style);
    }

    /**
     * Sets the String property <b>style</b>.
     *
     * @param style
     */
    public final void setStyle(String style) {
        this.style = style;
    }

    /**
     * Gets the String property <b>id</b>.
     *
     * @return String
     */
    public final String getId() {
        return (id);
    }

    /**
     * Sets the String property <b>id</b>.
     *
     * @param id
     */
    public final void setId(String id) {
        this.id = id;
    }

    /**
     * Gets the String property <b>other</b>.
     *
     * @return String
     */
    public final String getOther() {
        return (other);
    }

    /**
     * Sets the String property <b>other</b>.
     *
     * @param other
     */
    public final void setOther(String other) {
        this.other = other;
    }

    /**
     * Accepts the Visitor for enter behavior.
     *
     * @param visitor
     */
    public void enter(IRVisitor visitor) {
        visitor.enter(this);
    }

    /**
     * Accepts the Visitor for leave behavior.
     *
     * @param visitor
     */
    public void leave(IRVisitor visitor) {
        visitor.leave(this);
    }

    /**
     * Gets the IRNode property <b>parentRNode</b>.
     *
     * @return IRNode
     */
    public final IRNode getParentRNode() {
        return (parentRNode);
    }

    /**
     * Sets the IRNode property <b>parentRNode</b>.
     *
     * @param parentRNode
     */
    public final void setParentRNode(IRNode parentRNode) {
        this.parentRNode = parentRNode;
    }

    /**
     * Gets child RNodes.
     *
     * @return IRNode[]
     */
    public IRNode[] getRNodes() {
        java.util.List classNodes = new java.util.ArrayList();
        IRNode[] nodes = new IRNode[classNodes.size()];
        return ((IRNode[])classNodes.toArray(nodes));
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>MMaligngroup</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer2.isTargetElement(element, "http://www.w3.org/1998/Math/MathML", "maligngroup")) {
            return (false);
        }
        RStack target = new RStack(element);
        Element child;
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>MMaligngroup</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>MMaligngroup</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
