/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2000  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.xml.processor;

import java.io.*;
import java.net.URL;
import org.w3c.dom.*;
import com.ibm.xml.parser.Parser;
import jp.gr.java_conf.jaba2.xml.IProcessor;

/**
 * XML4J1Processor
 *
 * @since   Jul. 28, 1999
 * @version Jul. 20, 2000
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class XML4J1Processor extends AbstractProcessor {
    public XML4J1Processor() {
    }

    public Document parseDocument(URL url) throws IOException {
	Parser parser = new Parser(url.toString());
	return (parser.readStream(url.openStream()));
    }

    public Document parseDocumentByText(String text) throws IOException {
	Parser parser = new Parser("source");
	return (parser.readStream(new StringBufferInputStream(text)));
    }

    public Document parseValidDocument(URL url) throws IOException {
	throw (new UnsupportedOperationException());
    }

    public Document parseValidDocumentByText(String text) throws IOException {
	throw (new UnsupportedOperationException());
    }

    public Document newDocument() {
	throw (new UnsupportedOperationException());
    }
}
