/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2001  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.xml.relax.cooked;

import java.util.*;
import org.w3c.dom.*;
import jp.gr.java_conf.jaba2.util.UArray;
import jp.gr.java_conf.jaba2.xml.relax.raw.*;

/**
 * CPattern
 *
 * @since   Dec. 24, 1999
 * @version Jun. 18, 2001
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public abstract class CPattern extends CNode {
    protected String name_;
    private String namespace_;
    private CModule module_;
    private List contents_ = new ArrayList(); // List<ICPatternContent>

    public CPattern(String name, CModule module) {
	name_ = name;
	module_ = module;
    }

    public CPattern(RPattern rpattern, CModule module) {
	super(rpattern);
	name_ = rpattern.getName();
	namespace_ = rpattern.getNamespace();
	module_ = module;
	_setup(rpattern);
    }

    private void _setup(RPattern rpattern) {
	RNode[] rcontents = rpattern.getContents();
	for (int i = 0;i < rcontents.length;i++) {
	    RNode rcontent = rcontents[i];
	    if (rcontent instanceof RAttribute) {
		contents_.add(new CAttribute((RAttribute)rcontent, module_));
	    } else if (rcontent instanceof RRef) {
		contents_.add(new CRefWithPattern((RRef)rcontent, module_));
	    } else if (rcontent instanceof RAnyOtherAttribute) {
		contents_.add(
		    new CAnyOtherAttribute(
			(RAnyOtherAttribute)rcontent,
			module_
		    )
		);
	    } else {
		// XXX : do nothing
		throw (new CSyntaxErrorException("invalid contents in tag"));
	    }
	}
    }

    public String getName() {
	return (name_);
    }

    public String getNamespace() {
	return (namespace_);
    }

    public void combinePattern(RPattern rpattern) {
	_setup(rpattern);
    }

    public void addContent(ICPatternContent content) {
	contents_.add(content);
    }

    public ICPatternContent[] getContents() {
	ICPatternContent[] contents = new ICPatternContent[contents_.size()];
	return ((ICPatternContent[])contents_.toArray(contents));
    }
}
