package jp.gr.java_conf.jaba2.xml.relaxng.rRelaxng;

import java.io.*;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <b>RNNameChoice</b> is generated by Relaxer based on relaxNg.rxm.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <elementRule label="nameChoice">
 *   <tag name="choice">
 *     <attribute name="datatypeLibrary" type="ngURI"/>
 *   </tag>
 *   <hedgeRef label="nameClassHedge" occurs="+"/>
 * </elementRule>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;elementRule label="nameChoice"&gt;
 *   &lt;tag name="choice"&gt;
 *     &lt;attribute name="datatypeLibrary" type="ngURI"/&gt;
 *   &lt;/tag&gt;
 *   &lt;hedgeRef label="nameClassHedge" occurs="+"/&gt;
 * &lt;/elementRule&gt;
 * </pre>
 *
 * @version relaxNg.rxm (Thu Jul 25 16:29:03 JST 2002)
 * @author  Relaxer 0.17b (http://www.relaxer.org)
 */
public class RNNameChoice implements java.io.Serializable, IRNSContainer, IRNode, IRNExceptChoice, IRNNameClassHedgeChoice {
    private RNSContext rNSContext_ = new RNSContext(this, "http://relaxng.org/ns/structure/1.0");
    private String datatypeLibrary_;
    // List<IRNNameClassHedgeChoice>
    private java.util.List nameClassHedge_ = new java.util.ArrayList();
    private Element xmlElement;
    private IRNode parentRNode_;

    /**
     * Creates a <code>RNNameChoice</code>.
     *
     */
    public RNNameChoice() {
    }

    /**
     * Creates a <code>RNNameChoice</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public RNNameChoice(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>RNNameChoice</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public RNNameChoice(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>RNNameChoice</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public RNNameChoice(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>RNNameChoice</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public RNNameChoice(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>RNNameChoice</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public RNNameChoice(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>RNNameChoice</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public RNNameChoice(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>RNNameChoice</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public RNNameChoice(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>RNNameChoice</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public RNNameChoice(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>RNNameChoice</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public RNNameChoice(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>RNNameChoice</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>RNNameChoice</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>RNNameChoice</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        setup(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        xmlElement = element;
        IRelaxNgFactory factory = RelaxNgFactory.getFactory();
        RStack stack = new RStack(element);
        rNSContext_.declareNamespace(element);
        datatypeLibrary_ = URelaxer.getAttributePropertyAsString(element, "datatypeLibrary");
        nameClassHedge_.clear();
        while (!stack.isEmptyElement()) {
            if (RNNsName.isMatch(stack)) {
                addNameClassHedge(factory.createRNNsName(stack));
            } else if (RNAnyName.isMatch(stack)) {
                addNameClassHedge(factory.createRNAnyName(stack));
            } else if (RNNameChoice.isMatch(stack)) {
                addNameClassHedge(factory.createRNNameChoice(stack));
            } else if (RNName.isMatch(stack)) {
                addNameClassHedge(factory.createRNName(stack));
            } else {
                if (!URelaxer2.consumeElement(stack, "http://relaxng.org/ns/structure/1.0")) {
                    break;
        }
            }
        }
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElementNS("http://relaxng.org/ns/structure/1.0", "choice");
        rNSContext_.setupNamespace(element);
        int size;
        if (this.datatypeLibrary_ != null) {
            URelaxer.setAttributePropertyByString(element, "datatypeLibrary", this.datatypeLibrary_);
        }
        size = this.nameClassHedge_.size();
        for (int i = 0;i < size;i++) {
            IRNNameClassHedgeChoice value = (IRNNameClassHedgeChoice)this.nameClassHedge_.get(i);
            value.makeElement(element);
        }
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>RNNameChoice</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>RNNameChoice</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>RNNameChoice</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>RNNameChoice</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>RNNameChoice</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>RNNameChoice</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the RNSContext property <b>rNSContext</b>.
     *
     * @return RNSContext
     */
    public final RNSContext getRNSContext() {
        return (rNSContext_);
    }

    /**
     * Sets the RNSContext property <b>rNSContext</b>.
     *
     * @param rNSContext
     */
    public final void setRNSContext(RNSContext rNSContext) {
        this.rNSContext_ = rNSContext;
    }

    /**
     * Gets the String property <b>datatypeLibrary</b>.
     *
     * @return String
     */
    public final String getDatatypeLibrary() {
        return (datatypeLibrary_);
    }

    /**
     * Sets the String property <b>datatypeLibrary</b>.
     *
     * @param datatypeLibrary
     */
    public final void setDatatypeLibrary(String datatypeLibrary) {
        this.datatypeLibrary_ = datatypeLibrary;
    }

    /**
     * Gets the IRNNameClassHedgeChoice property <b>nameClassHedge</b>.
     *
     * @return IRNNameClassHedgeChoice[]
     */
    public final IRNNameClassHedgeChoice[] getNameClassHedge() {
        IRNNameClassHedgeChoice[] array = new IRNNameClassHedgeChoice[nameClassHedge_.size()];
        return ((IRNNameClassHedgeChoice[])nameClassHedge_.toArray(array));
    }

    /**
     * Sets the IRNNameClassHedgeChoice property <b>nameClassHedge</b>.
     *
     * @param nameClassHedge
     */
    public final void setNameClassHedge(IRNNameClassHedgeChoice[] nameClassHedge) {
        this.nameClassHedge_.clear();
        this.nameClassHedge_.addAll(java.util.Arrays.asList(nameClassHedge));
        for (int i = 0;i < nameClassHedge.length;i++) {
            nameClassHedge[i].setParentRNode(this);
        }
    }

    /**
     * Sets the IRNNameClassHedgeChoice property <b>nameClassHedge</b>.
     *
     * @param nameClassHedge
     */
    public final void setNameClassHedge(IRNNameClassHedgeChoice nameClassHedge) {
        this.nameClassHedge_.clear();
        this.nameClassHedge_.add(nameClassHedge);
        if (nameClassHedge != null) {
            nameClassHedge.setParentRNode(this);
        }
    }

    /**
     * Adds the IRNNameClassHedgeChoice property <b>nameClassHedge</b>.
     *
     * @param nameClassHedge
     */
    public final void addNameClassHedge(IRNNameClassHedgeChoice nameClassHedge) {
        this.nameClassHedge_.add(nameClassHedge);
        if (nameClassHedge != null) {
            nameClassHedge.setParentRNode(this);
        }
    }

    /**
     * Gets number of the IRNNameClassHedgeChoice property <b>nameClassHedge</b>.
     *
     * @return int
     */
    public final int getNameClassHedgeCount() {
        return (nameClassHedge_.size());
    }

    /**
     * Gets the IRNNameClassHedgeChoice property <b>nameClassHedge</b> by index.
     *
     * @param index
     * @return IRNNameClassHedgeChoice
     */
    public final IRNNameClassHedgeChoice getNameClassHedge(int index) {
        return ((IRNNameClassHedgeChoice)nameClassHedge_.get(index));
    }

    /**
     * Sets the IRNNameClassHedgeChoice property <b>nameClassHedge</b> by index.
     *
     * @param index
     * @param nameClassHedge
     */
    public final void setNameClassHedge(int index, IRNNameClassHedgeChoice nameClassHedge) {
        this.nameClassHedge_.set(index, nameClassHedge);
    }

    /**
     * Adds the IRNNameClassHedgeChoice property <b>nameClassHedge</b> by index.
     *
     * @param index
     * @param nameClassHedge
     */
    public final void addNameClassHedge(int index, IRNNameClassHedgeChoice nameClassHedge) {
        this.nameClassHedge_.add(index, nameClassHedge);
    }

    /**
     * Remove the IRNNameClassHedgeChoice property <b>nameClassHedge</b> by index.
     *
     * @param index
     */
    public final void removeNameClassHedge(int index) {
        nameClassHedge_.remove(index);
    }

    /**
     * Remove the IRNNameClassHedgeChoice property <b>nameClassHedge</b> by object.
     *
     * @param nameClassHedge
     */
    public final void removeNameClassHedge(IRNNameClassHedgeChoice nameClassHedge) {
        this.nameClassHedge_.remove(nameClassHedge);
    }

    /**
     * Clear the IRNNameClassHedgeChoice property <b>nameClassHedge</b>.
     *
     */
    public final void clearNameClassHedge() {
        nameClassHedge_.clear();
    }

    /**
     * Gets the element to use object construction.
     *
     * @return Element
     */
    public Element getXMLElement() {
        return (xmlElement);
    }

    /**
     * Makes a XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        String prefix = rNSContext_.getPrefixByUri("http://relaxng.org/ns/structure/1.0");
        buffer.append("<");
        URelaxer.makeQName(prefix, "choice", buffer);
        rNSContext_.makeNSMappings(buffer);
        if (datatypeLibrary_ != null) {
            buffer.append(" ");
            buffer.append("datatypeLibrary");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getDatatypeLibrary())));
            buffer.append("\"");
        }
        buffer.append(">");
        size = this.nameClassHedge_.size();
        for (int i = 0;i < size;i++) {
            IRNNameClassHedgeChoice value = (IRNNameClassHedgeChoice)this.nameClassHedge_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.append("</");
        URelaxer.makeQName(prefix, "choice", buffer);
        buffer.append(">");
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        String prefix = rNSContext_.getPrefixByUri("http://relaxng.org/ns/structure/1.0");
        buffer.print("<");
        URelaxer.makeQName(prefix, "choice", buffer);
        rNSContext_.makeNSMappings(buffer);
        if (datatypeLibrary_ != null) {
            buffer.print(" ");
            buffer.print("datatypeLibrary");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getDatatypeLibrary())));
            buffer.print("\"");
        }
        buffer.print(">");
        size = this.nameClassHedge_.size();
        for (int i = 0;i < size;i++) {
            IRNNameClassHedgeChoice value = (IRNNameClassHedgeChoice)this.nameClassHedge_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.print("</");
        URelaxer.makeQName(prefix, "choice", buffer);
        buffer.print(">");
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getDatatypeLibraryAsString() {
        return (URelaxer.getString(getDatatypeLibrary()));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setDatatypeLibraryByString(String string) {
        setDatatypeLibrary(URelaxer.getString(string));
    }

    /**
     * Returns a String representation of this object.
     * While this method informs as XML format representaion, 
     *  it's purpose is just information, not making 
     * a rigid XML documentation.
     *
     * @return String
     */
    public String toString() {
        try {
            return (makeTextDocument());
        } catch (Exception e) {
            return (super.toString());
        }
    }

    /**
     * Gets the IRNode property <b>parentRNode</b>.
     *
     * @return IRNode
     */
    public final IRNode getParentRNode() {
        return (parentRNode_);
    }

    /**
     * Sets the IRNode property <b>parentRNode</b>.
     *
     * @param parentRNode
     */
    public final void setParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    /**
     * Gets child RNodes.
     *
     * @return IRNode[]
     */
    public IRNode[] getRNodes() {
        java.util.List classNodes = new java.util.ArrayList();
        classNodes.addAll(nameClassHedge_);
        IRNode[] nodes = new IRNode[classNodes.size()];
        return ((IRNode[])classNodes.toArray(nodes));
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>RNNameChoice</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer2.isTargetElement(element, "http://relaxng.org/ns/structure/1.0", "choice")) {
            return (false);
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        Element child;
        if (RNNsName.isMatchHungry(target)) {
            $match$ = true;
        } else if (RNAnyName.isMatchHungry(target)) {
            $match$ = true;
        } else if (RNNameChoice.isMatchHungry(target)) {
            $match$ = true;
        } else if (RNName.isMatchHungry(target)) {
            $match$ = true;
        } else {
            return (false);
        }
        while (!target.isEmptyElement()) {
            if (RNNsName.isMatchHungry(target)) {
                $match$ = true;
            } else if (RNAnyName.isMatchHungry(target)) {
                $match$ = true;
            } else if (RNNameChoice.isMatchHungry(target)) {
                $match$ = true;
            } else if (RNName.isMatchHungry(target)) {
                $match$ = true;
            } else {
                if (!URelaxer2.consumeElement(target, "http://relaxng.org/ns/structure/1.0")) {
                    break;
        }
            }
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>RNNameChoice</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>RNNameChoice</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
