/*
 * The JabaJaba class library
 *  Copyright (C) 1997-1999  ASAMI, Tomoharu (tasami@ibm.net)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.xml.schema;

import org.w3c.dom.*;

/**
 * BuiltinName
 *
 * ID | IDREF | IDREFS | NMTOKEN | NMTOKENS | ENTITY | ENTITIES |
 * string | uri | binary | number | integer | real | decimal |
 * dateTime | date | time | timePeriod
 *
 * @since   Aug. 17, 1999
 * @version Aug. 18, 1999
 * @author  ASAMI, Tomoharu (tasami@ibm.net)
 */
public class BuiltinName extends DataTypeName {
    public BuiltinName(Element root) {
	super(root);
    }

    public static BuiltinName createBuiltinName(Element root) {
	return (new BuiltinName(root));
    }

    public static boolean isBuiltinName(String name) {
	if ("ID".equals(name) ||
	    "IDREF".equals(name) ||
	    "IDREFS".equals(name) ||
	    "NMTOKEN".equals(name) ||
	    "NMTOKENS".equals(name) ||
	    "ENTITY".equals(name) ||
	    "ENTITIES".equals(name) ||
	    "string".equals(name) ||
	    "uri".equals(name) ||
	    "binary".equals(name) ||
	    "number".equals(name) ||
	    "integer".equals(name) ||
	    "real".equals(name) ||
	    "decimal".equals(name) ||
	    "dateTime".equals(name) ||
	    "date".equals(name) ||
	    "time".equals(name) ||
	    "timePeriod".equals(name)) {

	    return (true);
	} else {
	    return (false);
	}
    }
}
