/*
 * RelaxerOrg class library
 *  Copyright (C) 2000-2002  ASAMI, Tomoharu (asami@relaxer.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.relaxer.dialog;

import java.io.IOException;

/**
 * IDialogSpace
 *
 * @since   Jun. 30, 2001
 * @version Feb. 27, 2002
 * @author  ASAMI, Tomoharu (asami@relaxer.org)
 */
public interface IDialogSpace {
    String getId();
    IDialogSlot getSlot(String name);
    IDialogCommand getCommand(String name);
    void open() throws IOException;
    void close() throws IOException;
    void flush() throws IOException;
    void setPathResolver(IPathResolver resolver);
    String resolve(String uri);
}
