/*
 * RelaxerOrg class library
 *  Copyright (C) 2000-2002  ASAMI, Tomoharu (asami@relaxer.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.relaxer.dialog;

import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.relaxer.tabular.ITabular;
import org.relaxer.util.URelaxer;
import org.relaxer.util.RObjectSlot;
import org.relaxer.dialog.rDialog.*;

/**
 * SimpleDialogSlot
 *
 * @since   Jul.  4, 2001
 * @version Feb. 28, 2002
 * @author  ASAMI, Tomoharu (asami@relaxer.org)
 */
public class SimpleDialogSlot extends AbstractDialogSlot {
    private RObjectSlot dataValue_ = new RObjectSlot();
    private IEntityAdapter reader_;
    private IEntityAdapter writer_;

    public SimpleDialogSlot(String name, Class type) {
	super(name, type);
	dataValue_.setType(type);
    }

    public SimpleDialogSlot(DSlot cSlot) throws ClassNotFoundException {
	super(cSlot.getName(), cSlot.getJavaClass());
	dataValue_.setType(getType());
	IDSlotChoice content = cSlot.getContent();
	if (content == null) {
	    reader_ = writer_ = null;
	} else if (content instanceof DRead) {
	    reader_ = _getAdapter(((DRead)content).getAccessMethod());
	    writer_ = null;
	} else if (content instanceof DWrite) {
	    writer_ = _getAdapter(((DWrite)content).getAccessMethod());
	    reader_ = null;
	} else if (content instanceof DReadWrite) {
	    DReadWrite method = (DReadWrite)content;
	    reader_ = writer_ = _getAdapter(method.getAccessMethod());
	} else if (content instanceof DReadAndWrite) {
	    DReadAndWrite method = (DReadAndWrite)content;
	    reader_ = _getAdapter(method.getRead().getAccessMethod());
	    writer_ = _getAdapter(method.getWrite().getAccessMethod());
	} else {
	    throw (new InternalError());
	}
    }

    private IEntityAdapter _getAdapter(IDAccessMethodChoice method) {
	if (method instanceof DFile) {
	    IEntityAdapter adapter = new FileEntityAdapter((DFile)method);
	    adapter.setDialogSlot(this);
	    return (adapter);
	} else if (method instanceof DBean) {
	    IEntityAdapter adapter = new BeanEntityAdapter((DBean)method);
	    adapter.setDialogSlot(this);
	    return (adapter);
	} else if (method instanceof DJdbc) {
	    IEntityAdapter adapter = new JdbcEntityAdapter((DJdbc)method);
	    adapter.setDialogSlot(this);
	    return (adapter);
	} else if (method instanceof DJms) {
	    IEntityAdapter adapter = new JmsEntityAdapter((DJms)method);
	    adapter.setDialogSlot(this);
	    return (adapter);
	} else {
	    throw (new InternalError());
	}
    }

    public void setReader(IEntityAdapter reader) {
	reader_ = reader;
    }

    public void setWrite(IEntityAdapter writer) {
	writer_ = writer;
    }

    public Document getDocument() throws ParserConfigurationException {
	return (dataValue_.getDocument());
    }

    public Document[] getDocuments() throws ParserConfigurationException {
	return (dataValue_.getDocuments());
    }

    public Object getRObject() {
	return (dataValue_.getRObject());
    }

    public Object[] getRObjects() {
	return (dataValue_.getRObjects());
    }

    public ITabular getTabular() {
	return (dataValue_.getTabular());
    }

    public void setDocument(Document doc) {
	dataValue_.setDocument(doc);
    }

    public void setDocuments(Document[] docs) {
	dataValue_.setDocuments(docs);
    }

    public void setDocument(Document doc, Class type) {
	dataValue_.setDocument(doc, type);
    }

    public void setDocuments(Document[] docs, Class type) {
	dataValue_.setDocuments(docs, type);
    }

    public void setRObject(Object value) {
	dataValue_.setRObject(value);
    }

    public void setRObjects(Object[] values) {
	dataValue_.setRObjects(values);
    }

    public void setTabular(ITabular tabular) {
	dataValue_.setTabular(tabular);
    }

    public void load() throws IOException {
	if (reader_ != null) {
	    dataValue_.setDocument(reader_.load());
	}
    }

    public void save() throws IOException {
	try {
	    if (writer_ != null) {
		writer_.save(dataValue_.getDocument());
	    }
	} catch (ParserConfigurationException e) {
	    throw (new IOException(e.getMessage()));
	}
    }
}
