/*
 * RelaxerOrg class library
 *  Copyright (C) 2000-2002  ASAMI, Tomoharu (asami@relaxer.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.relaxer.dialog.eDialog;

import java.lang.reflect.*;
import org.relaxer.dialog.*;
import org.relaxer.dialog.rDialog.*;

/**
 * EvalEjbAction
 *
 * @since   Feb. 26, 2002
 * @version Apr. 23, 2002
 * @author  ASAMI, Tomoharu (asami@relaxer.org)
 */
public class EvalEjbAction extends DEjbAction {
    public Object eval(Object[] params, IREvaluationContext context) {
//System.out.println("EvalEjbAction.eval");
	EvalContext cContext = (EvalContext)context;
	String uri = getUri();
	String javaClassName = getJavaClass();
	DEjbMethod ejbMethod = getEjbMethod();
	DEjbParam[] ejbParams = ejbMethod.getEjbParam();
//System.out.println(ejbParams.length);
	Class[] typeList = new Class[ejbParams.length];
	Object[] paramList = new Object[ejbParams.length];
	for (int i = 0;i < ejbParams.length;i++) {
	    DEjbParam ejbParam = ejbParams[i];
	    String slotName = ejbParam.getSlot();
	    IDialogSlot slot = cContext.space.getSlot(slotName);
//System.out.println(slot.getType());
//System.out.println(slot.getRObject());
	    typeList[i] = slot.getType();
	    paramList[i] = slot.getRObject();
	}
	return (
	    _invoke(
		javaClassName,
		uri,
		ejbMethod.getName(),
		typeList,
		paramList
	    )
	);
    }

    private Object _invoke(
	String javaClassName,
	String uri,
	String methodName,
	Class[] typeList,
	Object[] paramList
    ) {
//System.out.println("EvalEjbAction._invoke");
	try {
	    Class javaClass = Class.forName(javaClassName);
//System.out.println("javaClass = " + javaClass);
//System.out.println("uri =  " + uri);
	    Object proxy = _getProxyObject(javaClass, uri);
//System.out.println("proxy = " + proxy);
	    Method method = javaClass.getMethod(methodName, typeList);
//System.out.println("method(" + methodName + ")= " + method);
	    return (method.invoke(proxy, paramList));
	} catch (ClassNotFoundException e) {
//System.out.println("ClassNotFoundException");
	    throw (new IllegalArgumentException(e.getMessage()));
	} catch (NoSuchMethodException e) {
//System.out.println("NoSuchMethodException");
	    throw (new IllegalArgumentException(e.getMessage()));
	} catch (InstantiationException e) {
//System.out.println("InstantiationException");
	    throw (new IllegalArgumentException(e.getMessage()));
	} catch (IllegalAccessException e) {
//System.out.println("IllegalAccessException");
	    throw (new IllegalArgumentException(e.getMessage()));
	} catch (IllegalArgumentException e) {
//System.out.println("IllegalArgumentException");
	    throw (new IllegalArgumentException(e.getMessage()));
	} catch (InvocationTargetException e) {
//System.out.println("InvocationTargetException = " + e.getTargetException() + e.getTargetException().getMessage());
	    throw (new IllegalArgumentException(e.getMessage()));
	}
    }

    private Object _getProxyObject(
	Class javaClass,
	String uri
    ) throws NoSuchMethodException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
	Constructor constructor = javaClass.getConstructor(
	    new Class[] { String.class }
	);
	return (constructor.newInstance(new Object[] { uri }));
    }
}
