/*
 * RelaxerOrg class library
 *  Copyright (C) 2000-2002  ASAMI, Tomoharu (asami@relaxer.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.relaxer.goldenport;

import java.util.*;
import org.w3c.dom.*;

/**
 * PortNodeList
 *
 * @since   Mar. 11, 2002
 * @version Jul.  8, 2002
 * @author  ASAMI, Tomoharu (asami@relaxer.org)
 */
public class PortNodeList {
    private Document doc_;
    private Element element_;
    private List list_ = new ArrayList();

    public PortNodeList(Document doc) {
	doc_ = doc;
    }

    public Document getFactoryDocument() {
	return (doc_);
    }

    public void setup(Element element) {
	setElement(element);
	addChildren(element);
    }

    public void setup(PortNodeList list) {
	setElement(list.getElement());
	addChildren(list.getChildren());
    }

    public void setElement(Element element) {
	if (element == null) {
	    element_ = null;
	} else {
	    element_ = (Element)doc_.importNode(element, false);
	}
    }

    public void addChild(Node node) {
	list_.add(doc_.importNode(node, true));
    }

    public void addChildren(Node node) {
	NodeList children = node.getChildNodes();
	int size = children.getLength();
	for (int i = 0;i < size;i++) {
	    list_.add(doc_.importNode(children.item(i), true));
	}
    }

    public int size() {
	return (list_.size());
    }

    public Element getElement() {
	return (element_);
    }

    public Node getChild(int index) {
	return ((Node)list_.get(index));
    }

    public DocumentFragment getChildren() {
	DocumentFragment frag = doc_.createDocumentFragment();
	int size = list_.size();
	for (int i = 0;i < size;i++) {
	    Node child = (Node)list_.get(i);
	    frag.appendChild(child);
	}
	return (frag);
    }

    public Node makeNode() {
	if (element_ != null) {
	    element_.appendChild(getChildren());
	    return (element_);
	} else {
	    return (getChildren());
	}
    }
}
