/*
 * RelaxerOrg class library
 *  Copyright (C) 2000,2001  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.relaxer.monitor;

import java.util.*;
import java.io.*;
import java.sql.SQLException;
import javax.servlet.jsp.JspTagException;
import org.relaxer.util.UException;

/**
 * ULog
 *
 * @since   Jul. 17, 2001
 * @version Aug. 14, 2001
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public final class ULog {
    private static boolean debug__ = false;

    public static void setDebug(boolean debug) {
	debug__ = debug;
    }

    public static void log(String message) {
	if (debug__) {
	    System.err.print("[Log]");
	    System.err.println(message);
	}
    }

    public static void log(Throwable e) {
	if (debug__) {
	    System.err.println("[Log]");
	    e.printStackTrace();
	}
    }

    public static IOException makeIOException(String message) {
	log(message);
	return (UException.makeIOException(message));
    }

    public static IllegalArgumentException makeIllegalArgumentException(
	Throwable e
    ) {
	log(e);
	return (UException.makeIllegalArgumentException(e));
    }

    public static IOException makeIOException(Throwable e) {
	log(e);
	return (UException.makeIOException(e));
    }

    public static SQLException makeSQLException(Throwable e) {
	log(e);
	return (UException.makeSQLException(e));
    }

    public static JspTagException makeJspTagException(Throwable e) {
	log(e);
	return (UException.makeJspTagException(e));
    }
}
