/*
 * RelaxerOrg class library
 *  Copyright (C) 2000-2002  ASAMI, Tomoharu (asami@relaxer.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.relaxer.runtime.logger;

import java.util.*;
import java.io.*;
import org.relaxer.runtime.*;
import org.relaxer.runtime.datatype.RDateTime;

/**
 * AbstractPrintStreamLogger
 *
 * @since   Apr. 12, 2002
 * @version Apr. 12, 2002
 * @author  ASAMI, Tomoharu (asami@relaxer.org)
 */
public abstract class AbstractPrintStreamLogger extends AbstractStreamLogger {
    protected AbstractPrintStreamLogger() {
    }

    protected AbstractPrintStreamLogger(PrintWriter out) {
	super(out);
    }

    protected AbstractPrintStreamLogger(Writer out) {
	super(out);
    }

    protected AbstractPrintStreamLogger(OutputStream out) {
	super(out);
    }

    public void setup(Properties properties) {
    }

    public void log(String message) {
	_printTime();
	out_.println(message);
	out_.flush();
    }

    public void logEnter(Object object, String method) {
	_printTime();
	_printClassMethod(object, method);
	out_.print("()");
	out_.println();
	out_.flush();
    }

    public void logEnter(Object object, String method, String arg) {
	_printTime();
	_printClassMethod(object, method);
	out_.print("(");
	out_.print(arg);
	out_.print(")");
	out_.println();
	out_.flush();
    }

    public void logEnter(
	Object object,
	String method,
	String arg1,
	String arg2
    ) {
	_printTime();
	_printClassMethod(object, method);
	out_.print("(");
	out_.print(arg1);
	out_.print(", ");
	out_.print(arg2);
	out_.print(")");
	out_.println();
	out_.flush();
    }

    public void logEnter(Object object, String method, String arg1, String arg2, String arg3) {
	_printTime();
	_printClassMethod(object, method);
	out_.print("(");
	out_.print(arg1);
	out_.print(", ");
	out_.print(arg2);
	out_.print(", ");
	out_.print(arg3);
	out_.print(")");
	out_.println();
	out_.flush();
    }

    public void logEnter(Object object, String method, String[] args) {
	_printTime();
	_printClassMethod(object, method);
	out_.print("(");
	if (args.length > 0) {
	    out_.print(args[0]);
	    for (int i = 1;i < args.length;i++) {
		out_.print(", ");
		out_.print(args[i]);
	    }
	}
    }

    public void logLeave(Object object, String method) {
	_printTime();
	_printClassMethod(object, method);
	out_.print("-->void");
	out_.println();
	out_.flush();
    }

    public void logLeave(Object object, String method, String result) {
	_printTime();
	_printClassMethod(object, method);
	out_.print("-->");
	out_.print(result);
	out_.println();
	out_.flush();
    }

    public void logLeave(Object object, String method, Exception e) {
	_printTime();
	_printClassMethod(object, method);
	out_.print("-->");
	out_.print(e.getMessage());
	out_.println();
	out_.flush();
    }

    private void _printClassMethod(Object object, String method) {
	out_.print(object.getClass().getName());
	out_.print(".");
	out_.print(method);
    }

    private void _printTime() {
	out_.print(new RDateTime().toString());
	out_.print(" ");
    }
}
