package org.relaxer.runtime.rFactory;

import java.io.*;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <b>FComponentServer</b> is generated by Relaxer based on factory.rng.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <element name="server">
 *   <element name="className">
 *     <data type="token"/>
 *   </element>
 *   <zeroOrMore>
 *     <ref name="property"/>
 *   </zeroOrMore>
 * </element>
 * 
 * <element name="server">
 *   <element name="className">
 *     <data type="token"/>
 *   </element>
 *   <zeroOrMore>
 *     <ref name="property"/>
 *   </zeroOrMore>
 * </element>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;element name="server"&gt;
 *   &lt;element name="className"&gt;
 *     &lt;data type="token"/&gt;
 *   &lt;/element&gt;
 *   &lt;zeroOrMore&gt;
 *     &lt;ref name="property"/&gt;
 *   &lt;/zeroOrMore&gt;
 * &lt;/element&gt;
 * &lt;element name="server"&gt;
 *   &lt;element name="className"&gt;
 *     &lt;data type="token"/&gt;
 *   &lt;/element&gt;
 *   &lt;zeroOrMore&gt;
 *     &lt;ref name="property"/&gt;
 *   &lt;/zeroOrMore&gt;
 * &lt;/element&gt;
 * </pre>
 *
 * @version factory.rng (Tue Apr 09 14:39:26 JST 2002)
 * @author  Relaxer 0.16.1b (http://www.relaxer.org)
 */
public class FComponentServer implements java.io.Serializable {
    private String className_;
    // List<FProperty>
    private java.util.List property_ = new java.util.ArrayList();

    /**
     * Creates a <code>FComponentServer</code>.
     *
     */
    public FComponentServer() {
    }

    /**
     * Creates a <code>FComponentServer</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public FComponentServer(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>FComponentServer</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public FComponentServer(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>FComponentServer</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public FComponentServer(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>FComponentServer</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public FComponentServer(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>FComponentServer</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public FComponentServer(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>FComponentServer</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public FComponentServer(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>FComponentServer</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public FComponentServer(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>FComponentServer</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public FComponentServer(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>FComponentServer</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public FComponentServer(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>FComponentServer</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>FComponentServer</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>FComponentServer</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        setup(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        RStack stack = new RStack(element);
        className_ = URelaxer.getElementPropertyAsString(stack.popElement());
        property_.clear();
        while (!stack.isEmptyElement()) {
            if (FProperty.isMatch(stack)) {
                addProperty(new FProperty(stack));
            } else {
                break;
            }
        }
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElement("server");
        int size;
        URelaxer.setElementPropertyByString(element, "className", this.className_);
        size = this.property_.size();
        for (int i = 0;i < size;i++) {
            FProperty value = (FProperty)this.property_.get(i);
            value.makeElement(element);
        }
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>FComponentServer</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>FComponentServer</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>FComponentServer</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>FComponentServer</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>FComponentServer</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>FComponentServer</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the String property <b>className</b>.
     *
     * @return String
     */
    public final String getClassName() {
        return (className_);
    }

    /**
     * Sets the String property <b>className</b>.
     *
     * @param className
     */
    public final void setClassName(String className) {
        this.className_ = className;
    }

    /**
     * Gets the FProperty property <b>property</b>.
     *
     * @return FProperty[]
     */
    public final FProperty[] getProperty() {
        FProperty[] array = new FProperty[property_.size()];
        return ((FProperty[])property_.toArray(array));
    }

    /**
     * Sets the FProperty property <b>property</b>.
     *
     * @param property
     */
    public final void setProperty(FProperty[] property) {
        this.property_.clear();
        this.property_.addAll(java.util.Arrays.asList(property));
    }

    /**
     * Sets the FProperty property <b>property</b>.
     *
     * @param property
     */
    public final void setProperty(FProperty property) {
        this.property_.clear();
        this.property_.add(property);
    }

    /**
     * Adds the FProperty property <b>property</b>.
     *
     * @param property
     */
    public final void addProperty(FProperty property) {
        this.property_.add(property);
    }

    /**
     * Gets number of the FProperty property <b>property</b>.
     *
     * @return int
     */
    public final int getPropertyCount() {
        return (property_.size());
    }

    /**
     * Gets the FProperty property <b>property</b> by index.
     *
     * @param index
     * @return FProperty
     */
    public final FProperty getProperty(int index) {
        return ((FProperty)property_.get(index));
    }

    /**
     * Sets the FProperty property <b>property</b> by index.
     *
     * @param index
     * @param property
     */
    public final void setProperty(int index, FProperty property) {
        this.property_.set(index, property);
    }

    /**
     * Remove the FProperty property <b>property</b> by index.
     *
     * @param index
     */
    public final void removeProperty(int index) {
        property_.remove(index);
    }

    /**
     * Remove the FProperty property <b>property</b> by object.
     *
     * @param property
     */
    public final void removeProperty(FProperty property) {
        this.property_.remove(property);
    }

    /**
     * Clear the FProperty property <b>property</b>.
     *
     */
    public final void clearProperty() {
        property_.clear();
    }

    /**
     * Makes a XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        buffer.append("<server");
        buffer.append(">");
        buffer.append("<className>");
        buffer.append(URelaxer.escapeCharData(getClassName()));
        buffer.append("</className>");
        size = this.property_.size();
        for (int i = 0;i < size;i++) {
            FProperty value = (FProperty)this.property_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.append("</server>");
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        buffer.print("<server");
        buffer.print(">");
        buffer.print("<className>");
        buffer.print(URelaxer.escapeCharData(getClassName()));
        buffer.print("</className>");
        size = this.property_.size();
        for (int i = 0;i < size;i++) {
            FProperty value = (FProperty)this.property_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.print("</server>");
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getClassNameAsString() {
        return (URelaxer.getString(getClassName()));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setClassNameByString(String string) {
        setClassName(string);
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>FComponentServer</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "server")) {
            return (false);
        }
        RStack target = new RStack(element);
        Element child;
        child = target.popElement();
        if (child == null) {
            return (false);
        }
        if (!URelaxer.isTargetElement(child, "className")) {
            return (false);
        }
        while (!target.isEmptyElement()) {
            if (!FProperty.isMatchHungry(target)) {
                break;
            }
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>FComponentServer</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>FComponentServer</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
