package org.relaxer.runtime.rFactory;

import java.io.*;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <b>FContext</b> is generated by Relaxer based on factory.rng.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <element name="context">
 *   <zeroOrMore>
 *     <ref name="log"/>
 *   </zeroOrMore>
 *   <optional>
 *     <ref name="factory"/>
 *   </optional>
 * </element>
 * 
 * <element name="context">
 *   <zeroOrMore>
 *     <ref name="log"/>
 *   </zeroOrMore>
 *   <optional>
 *     <ref name="factory"/>
 *   </optional>
 * </element>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;element name="context"&gt;
 *   &lt;zeroOrMore&gt;
 *     &lt;ref name="log"/&gt;
 *   &lt;/zeroOrMore&gt;
 *   &lt;optional&gt;
 *     &lt;ref name="factory"/&gt;
 *   &lt;/optional&gt;
 * &lt;/element&gt;
 * &lt;element name="context"&gt;
 *   &lt;zeroOrMore&gt;
 *     &lt;ref name="log"/&gt;
 *   &lt;/zeroOrMore&gt;
 *   &lt;optional&gt;
 *     &lt;ref name="factory"/&gt;
 *   &lt;/optional&gt;
 * &lt;/element&gt;
 * </pre>
 *
 * @version factory.rng (Tue Apr 09 14:39:25 JST 2002)
 * @author  Relaxer 0.16.1b (http://www.relaxer.org)
 */
public class FContext implements java.io.Serializable {
    // List<FLog>
    private java.util.List log_ = new java.util.ArrayList();
    private FFactory factory_;

    /**
     * Creates a <code>FContext</code>.
     *
     */
    public FContext() {
    }

    /**
     * Creates a <code>FContext</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public FContext(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>FContext</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public FContext(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>FContext</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public FContext(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>FContext</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public FContext(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>FContext</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public FContext(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>FContext</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public FContext(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>FContext</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public FContext(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>FContext</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public FContext(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>FContext</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public FContext(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>FContext</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>FContext</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>FContext</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        setup(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        RStack stack = new RStack(element);
        log_.clear();
        while (!stack.isEmptyElement()) {
            if (FLog.isMatch(stack)) {
                addLog(new FLog(stack));
            } else {
                break;
            }
        }
        if (FFactory.isMatch(stack)) {
            setFactory(new FFactory(stack));
        }
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElement("context");
        int size;
        size = this.log_.size();
        for (int i = 0;i < size;i++) {
            FLog value = (FLog)this.log_.get(i);
            value.makeElement(element);
        }
        if (this.factory_ != null) {
            this.factory_.makeElement(element);
        }
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>FContext</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>FContext</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>FContext</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>FContext</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>FContext</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>FContext</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the FLog property <b>log</b>.
     *
     * @return FLog[]
     */
    public final FLog[] getLog() {
        FLog[] array = new FLog[log_.size()];
        return ((FLog[])log_.toArray(array));
    }

    /**
     * Sets the FLog property <b>log</b>.
     *
     * @param log
     */
    public final void setLog(FLog[] log) {
        this.log_.clear();
        this.log_.addAll(java.util.Arrays.asList(log));
    }

    /**
     * Sets the FLog property <b>log</b>.
     *
     * @param log
     */
    public final void setLog(FLog log) {
        this.log_.clear();
        this.log_.add(log);
    }

    /**
     * Adds the FLog property <b>log</b>.
     *
     * @param log
     */
    public final void addLog(FLog log) {
        this.log_.add(log);
    }

    /**
     * Gets number of the FLog property <b>log</b>.
     *
     * @return int
     */
    public final int getLogCount() {
        return (log_.size());
    }

    /**
     * Gets the FLog property <b>log</b> by index.
     *
     * @param index
     * @return FLog
     */
    public final FLog getLog(int index) {
        return ((FLog)log_.get(index));
    }

    /**
     * Sets the FLog property <b>log</b> by index.
     *
     * @param index
     * @param log
     */
    public final void setLog(int index, FLog log) {
        this.log_.set(index, log);
    }

    /**
     * Remove the FLog property <b>log</b> by index.
     *
     * @param index
     */
    public final void removeLog(int index) {
        log_.remove(index);
    }

    /**
     * Remove the FLog property <b>log</b> by object.
     *
     * @param log
     */
    public final void removeLog(FLog log) {
        this.log_.remove(log);
    }

    /**
     * Clear the FLog property <b>log</b>.
     *
     */
    public final void clearLog() {
        log_.clear();
    }

    /**
     * Gets the FFactory property <b>factory</b>.
     *
     * @return FFactory
     */
    public final FFactory getFactory() {
        return (factory_);
    }

    /**
     * Sets the FFactory property <b>factory</b>.
     *
     * @param factory
     */
    public final void setFactory(FFactory factory) {
        this.factory_ = factory;
    }

    /**
     * Makes a XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        buffer.append("<context");
        buffer.append(">");
        size = this.log_.size();
        for (int i = 0;i < size;i++) {
            FLog value = (FLog)this.log_.get(i);
            value.makeTextElement(buffer);
        }
        if (factory_ != null) {
            factory_.makeTextElement(buffer);
        }
        buffer.append("</context>");
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        buffer.print("<context");
        buffer.print(">");
        size = this.log_.size();
        for (int i = 0;i < size;i++) {
            FLog value = (FLog)this.log_.get(i);
            value.makeTextElement(buffer);
        }
        if (factory_ != null) {
            factory_.makeTextElement(buffer);
        }
        buffer.print("</context>");
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>FContext</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "context")) {
            return (false);
        }
        RStack target = new RStack(element);
        Element child;
        while (!target.isEmptyElement()) {
            if (!FLog.isMatchHungry(target)) {
                break;
            }
        }
        if (FFactory.isMatchHungry(target)) {
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>FContext</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>FContext</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
