package org.relaxer.runtime.rFactory;

import java.io.*;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <b>FLog</b> is generated by Relaxer based on factory.rng.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <element name="log">
 *   <choice>
 *     <element name="type">
 *       <data type="token"/>
 *     </element>
 *     <element name="className">
 *       <data type="token"/>
 *     </element>
 *   </choice>
 *   <zeroOrMore>
 *     <ref name="property"/>
 *   </zeroOrMore>
 * </element>
 * 
 * <element name="log">
 *   <choice>
 *     <element name="type">
 *       <data type="token"/>
 *     </element>
 *     <element name="className">
 *       <data type="token"/>
 *     </element>
 *   </choice>
 *   <zeroOrMore>
 *     <ref name="property"/>
 *   </zeroOrMore>
 * </element>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;element name="log"&gt;
 *   &lt;choice&gt;
 *     &lt;element name="type"&gt;
 *       &lt;data type="token"/&gt;
 *     &lt;/element&gt;
 *     &lt;element name="className"&gt;
 *       &lt;data type="token"/&gt;
 *     &lt;/element&gt;
 *   &lt;/choice&gt;
 *   &lt;zeroOrMore&gt;
 *     &lt;ref name="property"/&gt;
 *   &lt;/zeroOrMore&gt;
 * &lt;/element&gt;
 * &lt;element name="log"&gt;
 *   &lt;choice&gt;
 *     &lt;element name="type"&gt;
 *       &lt;data type="token"/&gt;
 *     &lt;/element&gt;
 *     &lt;element name="className"&gt;
 *       &lt;data type="token"/&gt;
 *     &lt;/element&gt;
 *   &lt;/choice&gt;
 *   &lt;zeroOrMore&gt;
 *     &lt;ref name="property"/&gt;
 *   &lt;/zeroOrMore&gt;
 * &lt;/element&gt;
 * </pre>
 *
 * @version factory.rng (Tue Apr 09 14:39:25 JST 2002)
 * @author  Relaxer 0.16.1b (http://www.relaxer.org)
 */
public class FLog implements java.io.Serializable {
    private IFLogChoice content_;
    // List<FProperty>
    private java.util.List property_ = new java.util.ArrayList();

    /**
     * Creates a <code>FLog</code>.
     *
     */
    public FLog() {
    }

    /**
     * Creates a <code>FLog</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public FLog(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>FLog</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public FLog(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>FLog</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public FLog(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>FLog</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public FLog(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>FLog</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public FLog(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>FLog</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public FLog(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>FLog</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public FLog(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>FLog</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public FLog(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>FLog</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public FLog(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>FLog</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>FLog</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>FLog</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        setup(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        RStack stack = new RStack(element);
        if (FLogType.isMatch(stack)) {
            setContent(new FLogType(stack));
        } else if (FLogClassName.isMatch(stack)) {
            setContent(new FLogClassName(stack));
        } else {
            throw (new IllegalArgumentException());
        }
        property_.clear();
        while (!stack.isEmptyElement()) {
            if (FProperty.isMatch(stack)) {
                addProperty(new FProperty(stack));
            } else {
                break;
            }
        }
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElement("log");
        int size;
        this.content_.makeElement(element);
        size = this.property_.size();
        for (int i = 0;i < size;i++) {
            FProperty value = (FProperty)this.property_.get(i);
            value.makeElement(element);
        }
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>FLog</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>FLog</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>FLog</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>FLog</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>FLog</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>FLog</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the IFLogChoice property <b>content</b>.
     *
     * @return IFLogChoice
     */
    public final IFLogChoice getContent() {
        return (content_);
    }

    /**
     * Sets the IFLogChoice property <b>content</b>.
     *
     * @param content
     */
    public final void setContent(IFLogChoice content) {
        this.content_ = content;
    }

    /**
     * Gets the FProperty property <b>property</b>.
     *
     * @return FProperty[]
     */
    public final FProperty[] getProperty() {
        FProperty[] array = new FProperty[property_.size()];
        return ((FProperty[])property_.toArray(array));
    }

    /**
     * Sets the FProperty property <b>property</b>.
     *
     * @param property
     */
    public final void setProperty(FProperty[] property) {
        this.property_.clear();
        this.property_.addAll(java.util.Arrays.asList(property));
    }

    /**
     * Sets the FProperty property <b>property</b>.
     *
     * @param property
     */
    public final void setProperty(FProperty property) {
        this.property_.clear();
        this.property_.add(property);
    }

    /**
     * Adds the FProperty property <b>property</b>.
     *
     * @param property
     */
    public final void addProperty(FProperty property) {
        this.property_.add(property);
    }

    /**
     * Gets number of the FProperty property <b>property</b>.
     *
     * @return int
     */
    public final int getPropertyCount() {
        return (property_.size());
    }

    /**
     * Gets the FProperty property <b>property</b> by index.
     *
     * @param index
     * @return FProperty
     */
    public final FProperty getProperty(int index) {
        return ((FProperty)property_.get(index));
    }

    /**
     * Sets the FProperty property <b>property</b> by index.
     *
     * @param index
     * @param property
     */
    public final void setProperty(int index, FProperty property) {
        this.property_.set(index, property);
    }

    /**
     * Remove the FProperty property <b>property</b> by index.
     *
     * @param index
     */
    public final void removeProperty(int index) {
        property_.remove(index);
    }

    /**
     * Remove the FProperty property <b>property</b> by object.
     *
     * @param property
     */
    public final void removeProperty(FProperty property) {
        this.property_.remove(property);
    }

    /**
     * Clear the FProperty property <b>property</b>.
     *
     */
    public final void clearProperty() {
        property_.clear();
    }

    /**
     * Makes a XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        buffer.append("<log");
        buffer.append(">");
        content_.makeTextElement(buffer);
        size = this.property_.size();
        for (int i = 0;i < size;i++) {
            FProperty value = (FProperty)this.property_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.append("</log>");
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        buffer.print("<log");
        buffer.print(">");
        content_.makeTextElement(buffer);
        size = this.property_.size();
        for (int i = 0;i < size;i++) {
            FProperty value = (FProperty)this.property_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.print("</log>");
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>FLog</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "log")) {
            return (false);
        }
        RStack target = new RStack(element);
        Element child;
        if (FLogType.isMatchHungry(target)) {
        } else if (FLogClassName.isMatchHungry(target)) {
        } else {
            return (false);
        }
        while (!target.isEmptyElement()) {
            if (!FProperty.isMatchHungry(target)) {
                break;
            }
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>FLog</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>FLog</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
