/*
 * The RelaxerOrg class library
 *  Copyright (C) 1997-2001  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.relaxer.tabular;

import java.util.StringTokenizer;
import java.io.IOException;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import org.relaxer.util.D2Array;

/**
 * CSVTabular
 *
 * @since   Jul. 11, 2001
 * @version Jul. 11, 2001
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class CSVTabular extends TabularDecorator {
    public CSVTabular(URL url) throws IOException {
	_init(url, "UTF-8");
    }

    public CSVTabular(URL url, String encoding) throws IOException {
	_init(url, encoding);
    }

    private void _init(URL url, String encoding) throws IOException {
	D2Array array = _makeArray(url, encoding);
	_setup(new D2ArrayTabular(array));
    }

    private D2Array _makeArray(URL url, String encoding)
	throws IOException {

	BufferedReader reader = new BufferedReader(
	    new InputStreamReader(url.openStream(), encoding)
	);
	D2Array array = new D2Array();
	String line;
	int y = 0;
	while ((line = reader.readLine()) != null) {
	    StringTokenizer st = new StringTokenizer(line, ",");
	    int x = 0;
	    while (st.hasMoreTokens()) {
		array.put(x, y, st.nextToken());
		x++;
	    }
	    y++;
	}
	return (array);
    }
}

