/*
 * The RelaxerOrg class library
 *  Copyright (C) 1997-2001  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.relaxer.tabular;

import java.sql.*;
import javax.sql.*;
import javax.naming.*;

/**
 * DataSourceTabularRepository
 *
 * @since   Aug. 13, 2001
 * @version Aug. 13, 2001
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class DataSourceTabularRepository extends JDBCTabularRepository {
    public DataSourceTabularRepository(
	String url,
	String tableName
    ) throws SQLException, NamingException {
	_setup(_createConnection(url), tableName);
    }

    public DataSourceTabularRepository(
	String url,
	String tableName,
	String username,
	String password
    ) throws SQLException, NamingException {
	_setup(_createConnection(url, username, password), tableName);
    }

    public DataSourceTabularRepository(
	Connection connection,
	String tableName
    ) throws SQLException {
	_setup(connection, tableName);
    }

    private Connection _createConnection(String url)
	throws SQLException, NamingException {

	if (url.startsWith("jdbc:")) {
	    return (DriverManager.getConnection(url));
	} else {
            Context ctx = new InitialContext();
            Object object = ctx.lookup(url);
            if (object instanceof XADataSource) {
                XADataSource xads = (XADataSource)object;
                XAConnection xacon = xads.getXAConnection();
                return (xacon.getConnection());
            } else if (object instanceof DataSource) {
                DataSource ds = (DataSource)object;
                return (ds.getConnection());
            } else {
                throw (new IllegalArgumentException());
            }
	}
    }

    private Connection _createConnection(
	String url,
	String username,
	String password
    ) throws SQLException, NamingException {
	if (url.startsWith("jdbc:")) {
	    return (DriverManager.getConnection(url));
	} else {
            Context ctx = new InitialContext();
            Object object = ctx.lookup(url);
            if (object instanceof XADataSource) {
                XADataSource xads = (XADataSource)object;
                XAConnection xacon = xads.getXAConnection(username, password);
                return (xacon.getConnection());
            } else if (object instanceof DataSource) {
                DataSource ds = (DataSource)object;
                return (ds.getConnection(username, password));
            } else {
                throw (new IllegalArgumentException());
            }
	}
    }
}
