/*
 * The RelaxerOrg class library
 *  Copyright (C) 1997-2001  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.relaxer.tabular;

import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/**
 * ITabular
 *
 * @since   Jul. 11, 2001
 * @version Aug. 12, 2001
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public interface ITabular {
    String XHTML_NS = "http://www.w3.org/1999/xhtml";
    String RXML_NS = "http://www.relaxer.org/xmlns/xml";

    String getName();
    int getWidth();
    int getHeight();
    String getLabel(int x);
    Object get(int x, int y);
    Document getDocument() throws ParserConfigurationException;
    Element getElement(Document doc);
}
