/*
 * The RelaxerOrg class library
 *  Copyright (C) 1997-2001  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.relaxer.taglib;

import java.io.IOException;
import javax.servlet.jsp.*;
import javax.servlet.jsp.tagext.*;
import javax.xml.parsers.*;
import org.xml.sax.SAXException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.relaxer.xml.UDOM;
import org.relaxer.util.URelaxer;
import org.relaxer.util.RObjectSlot;

/**
 * XMLImportTag
 *
 * @since   Aug. 15, 2001
 * @version Aug. 15, 2001
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class XMLImportTag extends AbstractRelaxerTag {
    private String uri_;
    private boolean isList_ = false;

    public void setUri(String uri) {
	uri_ = uri;
    }

    public String getUri() {
	return (uri_);
    }

    public void setList(String value) {
	isList_ = "true".equals(value);
    }

    public String isList() {
	return (isList_ ? "true" : "false");
    }

    protected Object _doEvaluate(RObjectSlot[] params)
	throws JspTagException {

	try {
	    DocumentBuilderFactory factory
		= DocumentBuilderFactory.newInstance();
	    DocumentBuilder builder = factory.newDocumentBuilder();
	    Document doc = builder.parse(_resolve(uri_));
	    if (isList_) {
		Element[] elements
		    = UDOM.getElements(doc.getDocumentElement());
		Document[] docs = new Document[elements.length];
		for (int i = 0;i < docs.length;i++) {
		    Document newDoc = builder.newDocument();
		    newDoc.appendChild(
			newDoc.importNode(elements[i], true)
		    );
		    docs[i] = newDoc;
		}
		return (docs);
	    } else {
		return (doc);
	    }
	} catch (ParserConfigurationException e) {
	    throw (_makeJspTagException(e));
	} catch (SAXException e) {
	    throw (_makeJspTagException(e));
	} catch (IOException e) {
	    throw (_makeJspTagException(e));
	}
    }
}
