/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2000  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.datatype;

import jp.gr.java_conf.jaba2.datatype.sql.SQLDatatype;
import jp.gr.java_conf.jaba2.datatype.xml.XMLDatatype;

/**
 * SimpleDatatype
 *
 * @since   Dec. 10, 2000
 * @version Dec. 10, 2000
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class SimpleDatatype implements IDatatype {
    private IJavaDatatype javaType_ = null;
    private IXMLDatatype xmlType_ = null;
    private ISQLDatatype sqlType_ = null;

    public SimpleDatatype(IJavaDatatype javaType) {
	javaType_ = javaType;
    }	

    public SimpleDatatype(IXMLDatatype xmlType) {
	xmlType_ = xmlType;
    }	

    public SimpleDatatype(ISQLDatatype sqlType) {
	sqlType_ = sqlType;
    }	

    public IJavaDatatype getJavaDatatype() {
	if (javaType_ != null) {
	    return (javaType_);
	}
	if (xmlType_ != null) {
	    javaType_ = UDatatype.getJavaDatatype(xmlType_);
	    return (javaType_);
	}
	if (sqlType_ != null) {
	    javaType_ = UDatatype.getJavaDatatype(sqlType_);
	    return (javaType_);
	}
	throw (new InternalError());
    }

    public IXMLDatatype getXMLDatatype() {
	if (xmlType_ != null) {
	    return (xmlType_);
	}
	if (sqlType_ != null) {
	    xmlType_ = UDatatype.getXMLDatatype(sqlType_);
	    return (xmlType_);
	}
	if (javaType_ != null) {
	    xmlType_ = UDatatype.getXMLDatatype(javaType_);
	    return (xmlType_);
	}
	throw (new InternalError());
    }

    public ISQLDatatype getSQLDatatype() {
	if (sqlType_ != null) {
	    return (sqlType_);
	}
	if (xmlType_ != null) {
	    sqlType_ = UDatatype.getSQLDatatype(xmlType_);
	    return (sqlType_);
	}
	if (javaType_ != null) {
	    sqlType_ = UDatatype.getSQLDatatype(javaType_);
	    return (sqlType_);
	}
	throw (new InternalError());
    }
}
