/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2000  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.dombus;

import java.io.IOException;
import java.net.URL;
import org.w3c.dom.*;
import javax.xml.parsers.*;
import org.xml.sax.SAXException;
import jp.gr.java_conf.jaba2.text.UString;
import jp.gr.java_conf.jaba2.dombus.config.*;
import jp.gr.java_conf.jaba2.dombus.configRelaxer.*;

/**
 * DOMBusConfig
 *
 * @since   Mar. 27, 2000
 * @version Aug. 28, 2000
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class DOMBusConfig extends CConfig {
    private DocumentBuilder builder_;

    public DOMBusConfig(URL configURL) 
	throws IOException, ParserConfigurationException, SAXException {

        DocumentBuilderFactory factory
            = DocumentBuilderFactory.newInstance();
        factory.setValidating(true);
        builder_ = factory.newDocumentBuilder();
//	builder.setErrorHandler(monitor.getSAXErrorHandler());
	Document doc = builder_.parse(configURL.toString());
	ConfigFileFactory.setFactory(new DOMBusConfigFileFactory());
	setup(doc);
    }

    public IComponentSlot[] getSlots() {
	CComponentSet cset = getComponentSet();
	CSlot[] cslots = cset.getSlot();
	IComponentSlot[] slots = new IComponentSlot[cslots.length];
	for (int i = 0;i < cslots.length;i++) {
	    slots[i] = _makeSlot(cslots[i]);
	}
	return (slots);
    }

    private IComponentSlot _makeSlot(CSlot cslot) {
	CComponent ccomp = cslot.getComponent();
	Object object = _makeObject(ccomp.getClassValue());
	if (cslot.getMultiThread()) {
	    return (new MTComponentSlot((IDOMBusComponent)object, cslot));
	} else {
	    return (new ComponentSlot((IDOMBusComponent)object, cslot));
	}
    }

    public IDOMBusContext[] getContexts() {
	CContextSet cset = getContextSet();
	if (cset != null) {
	    CContext[] contexts = cset.getContext();
	    IDOMBusContext[] slots = new IDOMBusContext[contexts.length];
	    for (int i = 0;i < slots.length;i++) {
		slots[i] = _makeIDOMBusContext(contexts[i]);
	    }
	    return (slots);
	} else {
	    return (null);
	}
    }

    private IDOMBusContext _makeIDOMBusContext(CContext cContext) {
	String name = cContext.getName();
	if (UString.isNull(name)) {
	    name = "*default*";
	}
	DOMBusContext context
	    = (DOMBusContext)_makeObject(cContext.getClassValue());
	context.setName(name);
	context.setResourceName(cContext.getResource());
	context.setUserPropertyFile(cContext.getUserPropertyFile());
	return (context);
    }

    private Object _makeObject(CClass clazz) {
	try {
	    String className = clazz.getName();
	    String classpath = clazz.getClasspath();
	    Class targetClass;
	    if (UString.isNull(classpath)) {
		targetClass = Class.forName(className);
	    } else {
		throw (new InternalError());
	    }
	    return (targetClass.newInstance());
	} catch (ClassNotFoundException e) {
	    throw (new InternalError(e.getMessage()));
	} catch (IllegalAccessException e) {
	    throw (new InternalError(e.getMessage()));
	} catch (InstantiationException e) {
	    throw (new InternalError(e.getMessage()));
	}
    }
}
