package jp.gr.java_conf.jaba2.dombus.configRelaxer;

import org.w3c.dom.*;

/**
 * <b>CContextRef</b> is generated by Relaxer based on ConfigFile.rlx.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <elementRule role="contextRef">
 *   <empty/>
 * </elementRule>
 * 
 * <tag name="contextRef">
 *   <attribute name="name" type="Name"/>
 *   <attribute name="role" required="true" type="Name"/>
 * </tag>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;elementRule role="contextRef"&gt;
 *   &lt;empty/&gt;
 * &lt;/elementRule&gt;
 * &lt;tag name="contextRef"&gt;
 *   &lt;attribute name="name" type="Name"/&gt;
 *   &lt;attribute name="role" required="true" type="Name"/&gt;
 * &lt;/tag&gt;
 * </pre>
 *
 * @version ConfigFile.rlx (Tue Aug 29 11:45:15 JST 2000)
 * @author  Relaxer 0.10.2b (by ASAMI@Yokohama)
 */
public class CContextRef implements java.io.Serializable {
    private String name;
    private String role;

    /**
     * Creates a <code>CContextRef</code>.
     *
     */
    public CContextRef() {
    }

    /**
     * Creates a <code>CContextRef</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public CContextRef(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>CContextRef</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public CContextRef(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>CContextRef</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public CContextRef(Element element) {
        setup(element);
    }

    /**
     * Initializes the <code>CContextRef</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>CContextRef</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>CContextRef</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        setup(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        IConfigFileFactory factory = ConfigFileFactory.getFactory();
        RStack stack = new RStack(element);
        name = URelaxer.getAttributePropertyAsString(element, "name");
        role = URelaxer.getAttributePropertyAsString(element, "role");
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElement("contextRef");
        int size;
        if (name != null) {
            URelaxer.setAttributePropertyByString(element, "name", name);
        }
        URelaxer.setAttributePropertyByString(element, "role", role);
        parent.appendChild(element);
    }

    /**
     * Gets the String property <b>name</b>.
     *
     * @return String
     */
    public final String getName() {
        return (name);
    }

    /**
     * Sets the String property <b>name</b>.
     *
     * @param name
     */
    public final void setName(String name) {
        this.name = name;
    }

    /**
     * Gets the String property <b>role</b>.
     *
     * @return String
     */
    public final String getRole() {
        return (role);
    }

    /**
     * Sets the String property <b>role</b>.
     *
     * @param role
     */
    public final void setRole(String role) {
        this.role = role;
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>CContextRef</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        String tagName = element.getTagName();
        if (!"contextRef".equals(tagName)) {
            return (false);
        }
        RStack target = new RStack(element);
        Element child;
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>CContextRef</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>CContextRef</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
