package jp.gr.java_conf.jaba2.dombus.configRelaxer;

import org.w3c.dom.*;

/**
 * <b>CPost</b> is generated by Relaxer based on ConfigFile.rlx.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <elementRule label="post" role="post">
 *   <ref label="postEvent" occurs="*"/>
 * </elementRule>
 * 
 * <tag name="post"/>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;elementRule label="post" role="post"&gt;
 *   &lt;ref label="postEvent" occurs="*"/&gt;
 * &lt;/elementRule&gt;
 * &lt;tag name="post"/&gt;
 * </pre>
 *
 * @version ConfigFile.rlx (Tue Aug 29 11:45:15 JST 2000)
 * @author  Relaxer 0.10.2b (by ASAMI@Yokohama)
 */
public class CPost implements java.io.Serializable {
    // List<CPostEvent>
    private java.util.List postEvent = new java.util.ArrayList();

    /**
     * Creates a <code>CPost</code>.
     *
     */
    public CPost() {
    }

    /**
     * Creates a <code>CPost</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public CPost(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>CPost</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public CPost(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>CPost</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public CPost(Element element) {
        setup(element);
    }

    /**
     * Initializes the <code>CPost</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>CPost</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>CPost</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        setup(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        IConfigFileFactory factory = ConfigFileFactory.getFactory();
        RStack stack = new RStack(element);
        postEvent.clear();
        while (!stack.isEmptyElement()) {
            if (CPostEvent.isMatch(stack)) {
                addPostEvent(factory.createCPostEvent(stack));
            } else {
                break;
            }
        }
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElement("post");
        int size;
        size = postEvent.size();
        for (int i = 0;i < size;i++) {
            CPostEvent value = (CPostEvent)this.postEvent.get(i);
            value.makeElement(element);
        }
        parent.appendChild(element);
    }

    /**
     * Gets the CPostEvent property <b>postEvent</b>.
     *
     * @return CPostEvent[]
     */
    public final CPostEvent[] getPostEvent() {
        CPostEvent[] array = new CPostEvent[postEvent.size()];
        return ((CPostEvent[])postEvent.toArray(array));
    }

    /**
     * Sets the CPostEvent property <b>postEvent</b>.
     *
     * @param postEvent
     */
    public final void setPostEvent(CPostEvent[] postEvent) {
        this.postEvent.clear();
        this.postEvent.addAll(java.util.Arrays.asList(postEvent));
    }

    /**
     * Adds the CPostEvent property <b>postEvent</b>.
     *
     * @param postEvent
     */
    public final void addPostEvent(CPostEvent postEvent) {
        this.postEvent.add(postEvent);
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>CPost</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        String tagName = element.getTagName();
        if (!"post".equals(tagName)) {
            return (false);
        }
        RStack target = new RStack(element);
        Element child;
        while (!target.isEmptyElement()) {
            if (!CPostEvent.isMatchHungry(target)) {
                break;
            }
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>CPost</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>CPost</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
