/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2000  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.dombus.importer;

import java.io.File;
import java.io.IOException;
import org.w3c.dom.*;
import jp.gr.java_conf.jaba2.io.UFile;
import jp.gr.java_conf.jaba2.parcel.IParcel;
import jp.gr.java_conf.jaba2.parcel.IGadget;
import jp.gr.java_conf.jaba2.parcel.UParcel;
import jp.gr.java_conf.jaba2.dombus.*;

/**
 * AbstractDOMBusImporter
 *
 * @since   Aug. 29, 2000
 * @version Aug. 31, 2000
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public abstract class AbstractDOMBusImporter extends AbstractDOMBusComponent
    implements IDOMBusImporter {

    public Object fire(DOMBusSignal signal) {
	try {
	    Object content = signal.getContent();
	    if (content instanceof IParcel) {
		return (_importByParcel((IParcel)content));
	    } else {
		return (_importByProperty(signal));
	    }
	} catch (IOException e) {
	    throw (new DOMBusException(e));
	}
    }

    private IParcel _importByParcel(IParcel parcel) throws IOException {
	return (importData(parcel));
    }

    private IParcel _importByProperty(DOMBusSignal signal) {
	throw (new UnsupportedOperationException());
    }
}
