package jp.gr.java_conf.jaba2.io;

import java.util.List;
import java.util.ArrayList;
import java.io.File;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import jp.gr.java_conf.jaba2.util.SimpleTableModel;
import jp.gr.java_conf.jaba2.awt.JTestFrame;

/**
 * DirectoryTableModel
 *
 * @since   Apr. 10, 1998
 * @version Nov. 20, 1998
 * @author  ASAMI, Tomoharu (tasami@ibm.net)
 */
public class DirectoryTableModel extends SimpleTableModel {
    protected File dir_;

    public DirectoryTableModel(File dir) {
	dir_ = dir;
	ColumnHandler[] handlers = new ColumnHandler[5];
	handlers[0] = new AbstractColumnHandler("type", "Type", String.class) {
	    public Object getValue(Object object) {
		File file = (File)object;
		if (file.isFile()) {
		    return ("File");
		} else if (file.isDirectory()) {
		    return ("Directory");
		} else {
		    throw (new InternalError("bad file type"));
		}
	    }
	};
	handlers[1] = new AbstractColumnHandler("name", "Name", String.class) {
	    public Object getValue(Object object) {
		File file = (File)object;
		return (file.getName());
	    }
	};
	handlers[2] = new AbstractColumnHandler(
	    "read", "Read", Boolean.class
	) {
	    public Object getValue(Object object) {
		File file = (File)object;
		return (new Boolean(file.canRead()));
	    }
	};
	handlers[3] = new AbstractColumnHandler(
	    "write", "Write", Boolean.class
	) {
	    public Object getValue(Object object) {
		File file = (File)object;
		return (new Boolean(file.canWrite()));
	    }
	};
	handlers[4] = new AbstractColumnHandler("size", "Size", Long.class) {
	    public Object getValue(Object object) {
		File file = (File)object;
		return (new Long(file.length()));
	    }
	};
	_setup(handlers, (Object[])null);
    }

    // SimpleTableModel
    protected void _updateData() {
	if (data_ != null) {
	    return;
	}
	if (dir_.isDirectory()) {
	    String names[] = dir_.list();	// XXX: filter
	    if (names != null) {
		data_ = new File[names.length];
		for (int i = 0;i < names.length;i++) {
		    data_[i] = new File(dir_, names[i]);
		}
	    } else {
		data_ = new File[0];
	    }
	} else {
	    if (data_ == null) {
		data_ = new File[1];
		data_[0] = dir_;
	    }
	}
    }

    // test driver
    public static void main(String[] args) {
	JTable jtable = new JTable(new DirectoryTableModel(new File(".")));
	javax.swing.JScrollPane pane = new javax.swing.JScrollPane(jtable);
	new JTestFrame(pane);
    }
}
